/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.rhwlab.LMS.DCCResponse;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.RNASeq.AWS;
import org.rhwlab.LMS.RNASeq.GridSubmitOld;
import org.rhwlab.LMS.RNASeq.LibraryID;
import org.rhwlab.LMS.dialogs.ChooseColumnsDialog;
import org.rhwlab.LMS.dialogs.GridSubmitParametersDialog;
import org.rhwlab.encode.FileUploadUrl;
import org.rhwlab.json.PrettyWriter;
import org.rhwlab.spreadsheet.config.Column;
import org.rhwlab.spreadsheet.config.GridSubmission;
import org.rhwlab.spreadsheet.config.JsonConfig;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
abstract public class SpreadSheetPanel extends JPanel {

    public SpreadSheetPanel() {
        this(false);
    }

    public SpreadSheetPanel(boolean addRows) {
        super(new BorderLayout());
        this.addRows = addRows;
    }

    public void updateDB() throws Exception {
        this.model.updateDb();
    }

    // determine if a new record can be added - does not conflict with existing records(primary key is unique)
    public boolean canAdd(HashMap<String, String> newData) {
        return true;
    }

    public void loadModelFromDB() throws Exception {
        String dbtable = model.getConfig().getDbTable();
        if (dbtable != null) {
            String sql = String.format("select * from %s", dbtable);
            loadModelFromDB(sql);
        }
    }

    public void loadModelFromDB(String sql) throws Exception {
        Filter[] filters = this.config.getFilter();
        this.loadModelFromDB(sql, filters);
    }

    public void loadModelFromDB(String sql, Filter[] filter) throws Exception {
        if (model.hasChanged()) {
            int ret = JOptionPane.showOptionDialog(this, "You have unsaved changes\nDo you want to save them?", "Unsaved Changes", JOptionPane.YES_NO_CANCEL_OPTION,
                    JOptionPane.WARNING_MESSAGE, null, saveOptions, null);
            if (ret == 0) {
                model.updateDb();
            } else if (ret == 2) {
                return;
            }
        }
        sqlSave = sql;
        if (filter == null) {
            model.loadFromDb(sql, new Filter[0]);
        } else {
            model.loadFromDb(sql, filter);
        }
    }

    // returns the rows added to the destination panel in view indexes
    public int[] addSelectedToMappedPanel(SpreadSheetPanel destPanel, LinkedHashMap<String, String> pairsMap, Object repeat, String[] required) {
        int[] rows = getConvertedSelectedRows();
        int[] ret = new int[rows.length];
        if (rows.length == 0) {
            return ret;
        }

        for (int r = 0; r < rows.length; ++r) {
            Integer repCount = null;
            if (repeat instanceof String) {
                repCount = new Integer(this.getValue(rows[r], (String) repeat));
            } else {
                repCount = (Integer) repeat;
            }
            for (int i = 0; i < repCount; ++i) {
                ret[r] = this.addToMappedPanel(rows[r], destPanel, pairsMap, required);
            }
        }
        return ret;
    }

    public int[] getConvertedSelectedRows() {
        int[] rows = this.getSelectedRows();
        int[] ret = new int[rows.length];
        RowSorter sorter = table.getRowSorter();
        for (int r = 0; r < rows.length; ++r) {
            ret[r] = sorter.convertRowIndexToModel(rows[r]);
        }
        return ret;
    }

    // rows are model rows
    public void setSelectedRows(int[] rows) {
        RowSorter sorter = table.getRowSorter();
        ListSelectionModel selModel = table.getSelectionModel();
        selModel.clearSelection();
        for (int row : rows) {
            int r = sorter.convertRowIndexToView(row);
            selModel.addSelectionInterval(r, r);
        }
    }

    public int getConvertedRow(int r) {
        RowSorter sorter = table.getRowSorter();
        return sorter.convertRowIndexToModel(r);
    }

    // add a record to the given model using mapped data columns from the given row of this panel's model
    // return the row in the dest panel view that was added
    public int addToMappedPanel(int r, SpreadSheetPanel destPanel, LinkedHashMap<String, String> pairsMap, String[] required) {
        // get the model for the panel
        SpreadSheetModel dest = destPanel.getModel();
        int ret = -1;
        if (model.hasData(r, required)) {
            int destRow = dest.addEmptyRow();  // make a new row in the destination model
            ret = destPanel.table.getRowSorter().convertRowIndexToView(destRow);
            destPanel.moveToRow(destRow);
            for (String sourceColumn : pairsMap.keySet()) {
                String destColumn = pairsMap.get(sourceColumn);
                if (destColumn != null) {
//System.out.printf("SourceColumn: %s\n", sourceColumn);                
                    int sourceC = config.getColumn(sourceColumn);

                    Column column = config.getColumn(sourceC);

                    CellBase cell = (CellBase) model.getValueAt(r, sourceC);
                    String data = cell.getValueAsString();
                    dest.setValue(destRow, destColumn, data, column.notifyOnMapping());
                    if (column.isKey()) {
                        cell.setEditable(false);
                    }
                }
            }
        }
        return ret;
    }

    public String getValue(int r, String sourceColumn) {
        int sourceC = config.getColumn(sourceColumn);
        CellBase cell = (CellBase) model.getValueAt(r, sourceC);
        String data = cell.getValueAsString();
        return data;
    }

    public Object getValueAsObject(int r, String sourceColumn) {
        int sourceC = config.getColumn(sourceColumn);
        CellBase cell = (CellBase) model.getValueAt(r, sourceC);
        return cell.getValue();
    }

    public CellBase getValueAsCellBase(int r, String sourceColumn) {
        int sourceC = config.getColumn(sourceColumn);
        CellBase cell = (CellBase) model.getValueAt(r, sourceC);
        return cell;
    }

    public void setConfig(SpreadSheet con) throws Exception {

        this.config = con;
        this.model = con.newModel();
        model.setConfig(config);
        table = new JTable(model);

        JTableHeader header = table.getTableHeader();
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
//        table.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer());

        table.setTransferHandler(new SSTransferHandler());
        table.setAutoCreateRowSorter(true);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

        TableColumnModel colModel = table.getColumnModel();
        int n = con.getColumnCount();
        // set up the editors 
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = colModel.getColumn(i);
            TableCellEditor editor = con.getColumn(i).newEditor();
            if (editor != null) {
                tableColumn.setCellEditor(editor);
            }
        }

        // set up any renderers
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = colModel.getColumn(i);
            TableCellRenderer rend = con.getColumn(i).newRenderer();
            if (rend != null) {
                tableColumn.setCellRenderer(rend);
            }
        }

        // set up Comparators for sorting column
        TableRowSorter sorter = (TableRowSorter) table.getRowSorter();
        for (int i = 0; i < n; ++i) {
            Comparator comp = con.getColumn(i).newCompare();
            if (comp != null) {
                sorter.setComparator(i, comp);
            }
        }

        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setFillsViewportHeight(true);
        /*
        // adjust the column widths to the headers
        TableCellRenderer headRenderer = table.getTableHeader().getDefaultRenderer();
        for (int i=0 ; i<n ; ++i){
            TableColumn col = table.getColumnModel().getColumn(i);
            Component headerComp = headRenderer.getTableCellRendererComponent(null,col.getHeaderValue(),false,false,0,0);
            Dimension dim = headerComp.getPreferredSize();
            col.setPreferredWidth(dim.width);
        }
         */
        for (int i = 0; i < n; ++i) {
            TableColumn col = table.getColumnModel().getColumn(i);
            Integer w = con.getColumn(i).getPreferredWidth();
            if (w != null) {
                //               col.setMinWidth(w);
                col.setPreferredWidth(w);
            } else {
                Component comp = headerRenderer.getTableCellRendererComponent(null, col.getHeaderValue(), false, false, 0, 0);
                int headerWidth = comp.getPreferredSize().width;
                col.setPreferredWidth(headerWidth);
//                col.setHeaderRenderer(headerRenderer);
//                col.sizeWidthToFit();
                col.setResizable(true);
            }
        }

        // remove invisible columns from the view
        for (int i = n - 1; i >= 0; --i) {
            if (!con.getColumn(i).isVisible()) {
                table.removeColumn(table.getColumnModel().getColumn(i));
            }
        }

        //Create the scroll pane and add the table to it.
        scrollPane = new JScrollPane(table);

        //Add the scroll pane to this panel.
        add(scrollPane, BorderLayout.CENTER);
        if (addRows) {
            JButton addRowButton = new JButton("Add Row");
            addRowButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = model.addEmptyRow();

                    moveToRow(row);
                }
            });
            add(addRowButton, BorderLayout.SOUTH);
        }

        // get the default project for this panel
        String projectName = config.getProject();
        project = model.getLabeledCell("Project");
        if (projectName != null) {
            project.setValue(projectName);
        }
    }

    // returns the row indexes for the model in the order the rows are in the panel
    public int[] getModelRows() {
        RowSorter sorter = this.table.getRowSorter();
        int n = sorter.getViewRowCount();
        int[] ret = new int[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = sorter.convertRowIndexToModel(i);
        }
        return ret;
    }

    public void moveToRow(int modelRow) {
        scrollPane.setViewportView(table);
        ListSelectionModel selectionModel = table.getSelectionModel();

        int viewRow = table.getRowSorter().convertRowIndexToView(modelRow);
        selectionModel.setSelectionInterval(viewRow, viewRow);
        int lastRow = table.getModel().getRowCount() - 1;
        double f = (double) viewRow / (double) lastRow;
        JScrollBar bar = scrollPane.getVerticalScrollBar();
        BoundedRangeModel range = bar.getModel();
        bar.setValue((int) (f * range.getMaximum()));
    }

    public SpreadSheetModel getModel() {
        return model;
    }

    public String getTitle() {
        return config.getTitle();
    }

    public int[] getSelectedRows() {
        return table.getSelectedRows();
    }

    public SpreadSheet getConfig() {
        return config;
    }

    public RowSorter getRowSorter() {
        return table.getRowSorter();
    }

    public String getProject() {
        if (project != null) {
            return project.getValueAsString();
        } else {
            return "";
        }
    }

    public void setProject(String p) {
        if (project != null) {
            String currentProject = project.getValueAsString();
            if (!p.equals(currentProject)) {
                project.setValue(p);
            }
        }
    }

    public void cellSelection(boolean selection) {
        if (selection) {
            table.setCellSelectionEnabled(true);
        } else {
            table.setColumnSelectionAllowed(false);
            table.setRowSelectionAllowed(true);
        }
    }

    public String getSQL() {
        return sqlSave;
    }

    public void addGridParametersMenu() {
        if (config.getGridSubmits().isEmpty()) {
            return;
        }
        JMenu gridSubmitMenu = new JMenu("Submit Grid Job(s)");
        menu.add(gridSubmitMenu);
        JMenu gridParams = new JMenu("Change Grid Submission Parameters");
        menu.add(gridParams);
        for (GridSubmission submit : config.getGridSubmits()) {
            JMenuItem item = new JMenuItem(submit.getProgram());
            gridParams.add(item);
            GridSubmitParametersDialog dial = new GridSubmitParametersDialog(submit);
            item.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    dial.setVisible(true);
                }
            });

            JMenuItem submitItem = new JMenuItem(submit.getProgram());
            gridSubmitMenu.add(submitItem);
            submitItem.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    int c = config.getColumn(submit.getSubmittingColumn());
                    for (int row : SpreadSheetPanel.this.getConvertedSelectedRows()) {
                        try {
                            GridSubmittable submittable = (GridSubmittable) SpreadSheetPanel.this.getModel().getValueAt(row, c);
                            if (dial.getArrayjob() != null) {
                                if (dial.getArrayjob().contains("$")) {
                                    String[] tokens = dial.getArrayjob().split("$");
                                    int cc = config.getColumn(tokens[1]);
                                    int n = ((IntegerCell) SpreadSheetPanel.this.getModel().getValueAt(row, c)).getValueAsInteger();
                                    String job = String.format("%s%d", tokens[0], n);
                                    submittable.submit(dial.getProgram(), dial.getCores(), dial.getMemory(), dial.getHours(), dial.getQueue(), job, dial.getConcurrent());
                                }
                            } else {
                                submittable.submit(dial.getProgram(), dial.getCores(), dial.getMemory(), dial.getHours(), dial.getQueue(), null, 0);
                            }
                            Thread.sleep(500);
                        } catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                    try {
                        SpreadSheetPanel.this.updateDB();
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
        }
    }

    public void addGridErrorUpdateToMenu() {
        int dirIndex = config.getColumn("Directory");
        int errorCol = config.getColumn("GridErrorFiles");

        if (dirIndex == -1 || errorCol == -1) {
            return; // no directory or error in table
        }
        JMenuItem gridErrorItem = new JMenuItem("Update from Grid Error Files");
        gridErrorItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = getConvertedSelectedRows();
                for (int row : rows) {
                    String dir = SpreadSheetPanel.this.getValue(row, "Directory");
                    JsonObject json = GridSubmitOld.latestErrorFiles(new File(dir));
                    SpreadSheetPanel.this.getModel().setValue(row, "GridErrorFiles", json.toString(), true);
                }
            }
        });
        menu.add(gridErrorItem);
    }

    public void addJsonToMenu() {
        if (!config.getJsons().isEmpty()) {
            JMenuItem jsonMenuItem = new JMenuItem("Submit to DCC");
            jsonMenuItem.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = getConvertedSelectedRows();
                    for (int row : rows) {
                        StringBuilder sent = new StringBuilder();
                        StringBuilder response = new StringBuilder();

                        for (JsonConfig jsonConfig : config.getJsons()) {
                            boolean complete = true;
                            TreeMap<String, String> criteria = jsonConfig.getCriteria();
                            boolean meets = true;
                            for (String head : criteria.keySet()) {
                                String v = criteria.get(head);
                                if (!SpreadSheetPanel.this.getValue(row, head).equals(v)) {
                                    meets = false;
                                    break;
                                }
                            }
                            if (meets) {
                                TreeMap<String, String> data = new TreeMap<>();
                                Set<String> headers = jsonConfig.getColumnHeaders();
                                for (String header : headers) {
                                    String dataStr = SpreadSheetPanel.this.getValue(row, header);
                                    if (!dataStr.equals("")) {
                                        data.put(header, SpreadSheetPanel.this.getValue(row, header));
                                    }
                                }
                                if (complete) {
                                    JsonObject obj = jsonConfig.buildJson(data);
                                    sent.append(obj.toString());
                                    sent.append("\n");
                                    String sentStr = sent.toString();

                                    SpreadSheetPanel.this.getModel().setValue(row, "SubmittedDCC", sentStr, true);
                                    DCCResponse dccResp = (DCCResponse) SpreadSheetPanel.this.getValueAsCellBase(row, "DCCResponse");
                                    JsonObject json = jsonConfig.buildJson(data);
                                    String acc = "";

                                    if (jsonConfig.getSchemaName().equalsIgnoreCase("file")) {
                                        String fileType = json.getString("file_format");
                                        if (fileType.equalsIgnoreCase("fastq")) {
                                            String pair = json.getString("paired_end");
                                            Map<String, String> map = dccResp.getFileAccessions();
                                            if (!map.isEmpty()) {
                                                acc = map.get(pair);
                                            }
                                            int iuashdf = 0;
                                        }
                                    } else {
                                        acc = dccResp.getAccession(jsonConfig.getSchemaName());
                                    }

                                    if (jsonConfig.getSchemaName().equalsIgnoreCase("replicate")) {
                                        String sampleID = SpreadSheetPanel.this.getValue(row, "RNASampleID");
                                        String expAlias = String.format("robert-waterston:experiment_%s", sampleID);
                                        int rep = 1;
                                        String repStr = SpreadSheetPanel.this.getValue(row, "Replicate");
                                        if (!repStr.equals("")) {
                                            rep = Integer.valueOf(repStr);
                                        }
                                        try {
                                            acc = LibraryID.getUUID(expAlias, rep);
                                            int aosdhfuis = 0;
                                        } catch (Exception exc) {

                                        }
                                    }

                                    try {
                                        String responseStr;
                                        if (acc.equals("")) {
                                            String alias = json.getJsonArray("aliases").getString(0);
                                            responseStr = jsonConfig.patchJson(data, alias);
                                            if (jsonConfig.isError()) {
                                                responseStr = jsonConfig.postJson(data);
                                            }

                                        } else {
                                            responseStr = jsonConfig.patchJson(data, acc);
                                        }
//                                        String responseStr = jsonConfig.submitJson(data);
                                        if (responseStr == null) {
                                            PrettyWriter pretty = new PrettyWriter();
                                            pretty.write(jsonConfig.getResponse());
                                            String prettyJsonStr = pretty.getPrettyJson();
                                            JOptionPane.showMessageDialog(SpreadSheetPanel.this, prettyJsonStr, "Error returned from submission", JOptionPane.ERROR_MESSAGE);
                                            return;  // don't save the error response
                                        }
                                    } catch (Exception exc) {
                                        exc.printStackTrace();
                                    }
                                    response.append(jsonConfig.getResponse());
                                    response.append("\n");
                                }
                            }
                        }
                        // all the submissions returned without error - saving the dcc response
                        SpreadSheetPanel.this.getModel().setValue(row, "DCCResponse", response.toString(), true);

                        // if it is a file submission , start aws uploading
                        for (JsonConfig jsonConfig : config.getJsons()) {
                            if (jsonConfig.getSchemaName().equals("file")) {
                                String server = jsonConfig.getServer();
                                TreeMap<String, String> criteria = jsonConfig.getCriteria();
                                boolean meets = true;
                                for (String head : criteria.keySet()) {
                                    String v = criteria.get(head);
                                    if (!SpreadSheetPanel.this.getValue(row, head).equals(v)) {
                                        meets = false;
                                        break;
                                    }
                                }
                                if (meets) {
                                    // this row meets the json configuration criteria and is a file submission
                                    int idColumn = SpreadSheetPanel.this.getConfig().getColumn("DCCResponse");
                                    AWS id = (AWS) SpreadSheetPanel.this.getModel().getValueAt(row, idColumn);
                                    try {
                                        id.submit(server);
                                    } catch (Exception exc) {
                                        exc.printStackTrace();
                                    }
                                }
                            }
                        }

                    }
                    // save the db
                    try {
                        SpreadSheetPanel.this.updateDB();
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
            menu.add(jsonMenuItem);

            if (config.getJsonConfig("file") != null) {
                JMenuItem renew = new JMenuItem("Renew Credentials and Upload File");
                renew.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            renewCredentials();
                        } catch (Exception ex) {
                            Logger.getLogger(SpreadSheetPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                menu.add(renew);
            }
        }
    }

    private void renewCredentials() throws Exception {
 //       JsonConfig jsonConfig = config.getJsonConfig("file");
//        String server = jsonConfig.getServer();
        int[] rows = getConvertedSelectedRows();
        for (int row : rows) {
            
            
                        // if it is a file submission , start aws uploading
                        for (JsonConfig jsonConfig : config.getJsons()) {
                            if (jsonConfig.getSchemaName().equals("file")) {
                                String server = jsonConfig.getServer();
                                TreeMap<String, String> criteria = jsonConfig.getCriteria();
                                boolean meets = true;
                                for (String head : criteria.keySet()) {
                                    String v = criteria.get(head);
                                    if (!SpreadSheetPanel.this.getValue(row, head).equals(v)) {
                                        meets = false;
                                        break;
                                    }
                                }
                                if (meets) {
                                    // this row meets the json configuration criteria and is a file submission
                                    int idColumn = SpreadSheetPanel.this.getConfig().getColumn("DCCResponse");
                                    AWS id = (AWS) SpreadSheetPanel.this.getModel().getValueAt(row, idColumn);
                                    try {
                                        id.submit(server);
                                    } catch (Exception exc) {
                                        exc.printStackTrace();
                                    }
                                }
                            }
                        }            
            
            
            
            
/*            
            StringBuilder sent = new StringBuilder();
            StringBuilder response = new StringBuilder();
            String accCell = SpreadSheetPanel.this.getValue(row, "FileAccessions");
            if (!accCell.equals("")){
                String[] accs = accCell.split(",");
                for (String acc : accs){
                    FileUploadUrl url = new FileUploadUrl(server,acc);
                    JsonObjectBuilder builder = Json.createObjectBuilder();
                    
                    String cred = url.postJson(builder.build());
                    int iohid=0;
                }
            }
            int asdfuisdh=0;
*/
        }
    }

    public void uniqueSelectedValues() {
        if (chooseColumns == null) {
            chooseColumns = new ChooseColumnsDialog(config);
        }
        chooseColumns.setVisible(true);
        List selected = chooseColumns.getSelectedColumns();
        if (selected != null) {
            TreeSet<String> set = new TreeSet<>();
            int[] selectedRows = this.getConvertedSelectedRows();
            for (int r = 0; r < selectedRows.length; ++r) {
                StringBuilder builder = new StringBuilder();
                int row = selectedRows[r];
                for (Object obj : selected) {
                    String header = (String) obj;
                    String v = this.getValue(row, header);
                    builder.append(v);
                }
                set.add(builder.toString());
            }
            JOptionPane.showMessageDialog(this, String.format("%d unique values selected", set.size()));
        }
    }

    abstract public JMenu getMenu();
    static String[] options = {"Add Record(s)", "Cancel"};
    static String[] saveOptions = {"Save changes", "Discard changes", "Cancel"};
    boolean addRows;
    SpreadSheet config;
    SpreadSheetModel model;
    public JMenu menu;
    ;
    JTable table;
    JScrollPane scrollPane;
    CellBase project;
    String sqlSave;
    ChooseColumnsDialog chooseColumns = null;
}
