/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.rhwlab.LMS.BooleanCell;
import org.rhwlab.LMS.DateCell;
import org.rhwlab.LMS.DoubleCell;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.config.Cell;
import org.rhwlab.spreadsheet.config.Column;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class SpreadSheetModel extends DefaultTableModel {

    public SpreadSheetModel() {
    }
    // check the given column for the given value (look in db and model)
    // return true if the value is found in the column

    public boolean checkValue(String columnHead, String value) throws Exception {
        int col = config.getColumn(columnHead);
        if (this.isPresent(value, col)) {
            return true;  // check the loaded model for the value
        }
        Column column = config.getColumn(col);
        String dbColumn = column.getDbColumn();
        if (dbColumn != null) {
            // check the database for the value
            String sql = String.format("Select %s from %s where %s = ?", dbColumn, config.getDbTable(), dbColumn);
            PreparedStatement state = MySql.getMySql().getStatement(sql);
            state.setString(1, value);
            state.execute();
            ResultSet rs = state.getResultSet();
            if (rs.next()) {
                return true;
            }
        }
        return false;  // value is not present
    }

    public int findRecordMatchingValues(String[] columnHeads, String[] values, int starting) {
        int r = starting;
        while (r < this.getRowCount()) {
            boolean matched = true;
            for (int i = 0; i < values.length; ++i) {
                String columnHead = columnHeads[i];
                String value = values[i];
                int col = this.findColumn(columnHead);

                CellBase base = (CellBase) this.getValueAt(r, col);
                String cellValue = base.getValueAsString();
                if (!cellValue.equals(value)) {
                    matched = false;
                    break;
                }
            }
            if (matched) {
                return r;
            }
            ++r;
        }
        return -1;

    }
    // finds the next record that contains the given vlue in the given column from the starting record

    public int findRecordContainingValue(String columnHead, String value, int starting) {
        int r = starting;
        int col = this.findColumn(columnHead);
        while (r < this.getRowCount()) {
            CellBase base = (CellBase) this.getValueAt(r, col);
            String cellValue = base.getValueAsString();
            if (cellValue.contains(value)) {
                return r;
            }
            ++r;
        }
        return -1;
    }

    public int findRecordBeginingWithValue(String columnHead, String value, int[] rows) {
        int col = this.findColumn(columnHead);
        for (int r : rows) {
            CellBase base = (CellBase) this.getValueAt(r, col);
            String cellValue = base.getValueAsString();
            if (cellValue.startsWith(value)) {
                return r;
            }
        }
        return -1;
    }
    // remove a row - does not remove row loaded from the db

    public void removeRow(int r) {
        if (r >= this.lastLoadedRow) {
            super.removeRow(r);
        }
    }

    // is the given value present in the model in the given column
    public boolean isPresent(String newValue, int col) {
        int nRows = this.getRowCount();
        for (int r = 0; r < nRows; ++r) {
            CellBase base = (CellBase) this.getValueAt(r, col);
            String oldValue = base.getValueAsString();
            if (oldValue.equals(newValue)) {
                return true;
            }
        }
        return false;
    }

    // add the data in the columns in a file by matching the data in the given columns
    // this routine is not finished 
    public void addColumnsFromFile(File input, String[] matching) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        String line = reader.readLine();
        String[] heads = line.split(",");

        int[] index = new int[heads.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = config.getColumn(heads[i]);
        }

        line = reader.readLine();
        while (line != null) {



            line = reader.readLine();
        }
    }
    // is the cell at row,col editable?

    public boolean isCellEditable(int row, int col) {
        if (config.getColumn(col).isEditable()) {  // is the column editable?
            CellBase base = (CellBase) this.getValueAt(row, col);
            return base.isEditable();
        }
        return false;
    }

    public void setConfig(SpreadSheet config) throws Exception {
        this.config = config;
        int n = config.getColumnCount();

        // set up the columns
        for (int i = 0; i < n; ++i) {
            Column column = config.getColumn(i);
            this.addColumn(column.getHeader());

        }

        // add individual cells to the model
        for (Cell cell : config.getCells()) {
            CellBase base = (CellBase) cell.newObject();
            cells.put(cell.getLabel(), base);
            String defaultValue = cell.getDefaultValue();
            if (defaultValue != null) {
                base.setValue(defaultValue);
            }
        }

        // find the primary keys for the backing db table
        if (config.getDbTable() != null) {
            String sql = String.format("select table_name,column_name from information_schema.columns where table_name=\'%s\' and column_key=\'PRI\'", config.getDbTable());
            ResultSet rs = MySql.getMySql().execute(sql);
            while (rs.next()) {
                String tbl = rs.getString("table_name");
                if (tbl.equals(config.getDbTable())){
                    keys.add(rs.getString("column_name"));
                }
            }
        }

        // build an sql prepared statement to select using the primary key
        StringBuilder builder = new StringBuilder();
        builder.append("Select * from ");
        builder.append(config.getDbTable());
        builder.append(" where ");
        boolean first = true;
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            if (!first) {
                builder.append(" and ");
            }
            first = false;
            builder.append(key);
            builder.append(" = ? ");
        }
        this.primaryKeySelect = MySql.getMySql().getStatement(builder.toString());
    }

    public int addEmptyRow() {
        int n = config.getColumnCount();
        int r = getRowCount();
        Object[] row = buildRow(n,r);
        addRow(row);
        for (int i = 0; i < n; ++i) {
 //           CellBase base = (CellBase) this.getValueAt(r, i);
            CellBase base = (CellBase)row[i];
            Column column = config.getColumn(i);

            // set the default value
            String defaultValue = column.getDefault();
            if (defaultValue != null) {
                base.setDefault(defaultValue);
            }
        }
        this.fireTableDataChanged();
        return r;
    }

    public int addEmptyRowNoDefault() {
        int n = config.getColumnCount();
        int r = getRowCount();
        Object[] row = buildRow(n,r);
        addRow(row);
        return r; // return the row added
    }
    public Object[] buildRow(int n,int r){
       Object[] row = new Object[n];
        try {
            for (int i = 0; i < n; ++i) {
                Column col = config.getColumn(i);
                row[i] = col.newObject();
                if (col.getDbColumn() != null) {
                    ((CellBase) row[i]).setDBColumn(true);
                }
                if (col.notifyOnLoading()){
                    ((CellBase) row[i]).setNotifyOnLoad(true);
                }
            }
            // add the listeners to each cell in the row
            for (int i = 0; i < n; ++i) {

                Column col = config.getColumn(i);
                String[] listening = col.getListeningColumns();
                for (String listener : listening) {
                    int c = config.getColumn(listener);
                    try {
                    CellBase listenCell = (CellBase) row[c];
                    CellBase base = (CellBase) row[i];
                    base.addListener(listenCell);                    
                    } catch (Exception exc){
                        int saiudfis=0;
                    }

                }

            }
            // set up listeners to individual cells associated with the spreadsheet
            for (Cell cell : config.getCells()) {
                CellBase base = cells.get(cell.getLabel());
                base.setModel(this);
                String[] listening = cell.getListeningColumns();
                for (String listener : listening) {
                    int c = config.getColumn(listener);
                    CellBase listenCell = (CellBase) row[c];
                    base.addListener(listenCell);
                }
            }

            // set up the inputs to each cell
            for (int i = 0; i < n; ++i) {
                CellBase base = (CellBase) row[i];

                String[] inputCols = base.getInputColumns();
                for (String inputCol : inputCols) {
                    int c = config.getColumn(inputCol);
                    if (c != -1) {
                        base.addInput(inputCol, (CellBase) row[c]);
                    } else {
                        String className = base.getClass().getName();
//                        System.out.println(className);
                    }

                }
            }

        } catch (Exception exc) {
            exc.printStackTrace();
        }
        
        for (int i = 0; i < n; ++i) {
            CellBase base = (CellBase) row[i];
            base.setModel(this);
            base.setColumn(i);
            base.setRow(r);
            Column column = config.getColumn(i);
            for (String parameterName : column.getParameterNames()) {
                String parameterValue = column.getParameterValue(parameterName);
                base.setParameter(parameterName, parameterValue);
            }

        } 
        return row;
    }
    // adds data to this model from a tab file
    // only data in columns that have header values that match the spreadsheet column
    // names are added - the rest of the data is ignored

    public void addRowsFromFile(File input) throws Exception {
        //      this.setRowCount(0);
        BufferedReader reader = new BufferedReader(new FileReader(input));
        String line = reader.readLine();
        String[] heads = line.split("\t|,");

        int nCols = config.getColumnCount();
        Object[] row = new Object[nCols];
        int[] index = new int[nCols];    // the column in the file with the data for each column in the spreadsheet
        for (int i = 0; i < index.length; ++i) {
            index[i] = -1;
            String columnHead = config.getColumn(i).getHeader();
            for (int j = 0; j < heads.length; ++j) {
                if (columnHead.equals(heads[j])) {
                    index[i] = j;
                    break;
                }
            }
        }

        line = reader.readLine();
        while (line != null) {
            String[] values = line.split("\t|,");
            int r = this.addEmptyRow();
            for (int i = 0; i < nCols; ++i) {
                if (index[i] != -1) {
                    CellBase base = (CellBase) this.getValueAt(r, i);
                    if (index[i] < values.length) {
                        base.setValue(values[index[i]]);
                    }

                }
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public boolean setValue(int row, String column, Object value, boolean notify) {
        int col = config.getColumn(column);
        if (col == -1){
            System.out.printf("Unknown column: %s in SpreadSheetModel.setValue\n",column);
        }
        CellBase base = (CellBase) this.getValueAt(row, col);
        return base.setValue(value, notify);
    }
    // remove rows that do not fit the given filter

    public void refilter(Filter filter) {
        int nCol = this.getColumnCount();
        int nRow = this.getRowCount();
        for (int r = nRow - 1; r >= 0; --r) {
            for (int c = 0; c < nCol; ++c) {
                Column column = this.config.getColumn(c);
                CellBase value = (CellBase) this.getValueAt(r, c);
/*
                if (!filter.accept(column, value)) {
                    super.removeRow(r);
                    if (r <= this.lastLoadedRow) {
                        --this.lastLoadedRow;
                    }
                    break;
                }
 */
            }
        }
    }
    // build this model from all the rows in the db table

    public void loadAllFromDb() throws Exception {
        String dbName = config.getDbTable();
        if (dbName == null) {
            return;
        }
        String sql = String.format("Select * from %s", dbName);
        loadFromDb(sql, new Filter[0]);
    }
        public ResultSet loadFromDb(String sql, Filter filter) throws Exception {
            Filter[] a = new Filter[1];
            a[0] = filter;
            return loadFromDb(sql,a);
        }
    // build this model from the rows in the db table identified by the sql statement

    public ResultSet loadFromDb(String sql, Filter[] filters) throws Exception {
        if (this.hasChanged()){
            int option = JOptionPane.showConfirmDialog(null,"There are changes to the data that will be lost if you continue\nDo you want to continue?", "", JOptionPane.OK_CANCEL_OPTION);
            if (option != JOptionPane.OK_OPTION){
                return null;
            }
        }
        duringLoad = true;
        lastLoadedRow = -1;
        this.setRowCount(0);   // empties out the table
        primaryKeys = new ArrayList<String>();
        ResultSet rs = MySql.getMySql().execute(sql);
        int n = config.getColumnCount();
        while (rs.next()) {
            int r = -1;
            // get each column that has db data
            for (int i = 0; i < n; ++i) {
                Column column = config.getColumn(i);

                String dbCol = column.getDbColumn();
                String data = null;
                // get the data from the db
                if (dbCol != null) {
                    try {
                        data = rs.getString(dbCol);
                    } catch (Exception exc) {
//                        exc.printStackTrace();
                    }
                }

 /*               
                // is this a select column (built by selecting from another table)
                String select = column.getSelect();
                if (select != null) {
                    String selectCol = column.getSelectColumn();
                    data = rs.getString(selectCol);
                    sql = String.format(select, data);
                    ResultSet rs1 = MySql.getMySql().execute(sql);
                    if (rs1.next()) {
                        data = rs1.getString(1);
                    } else {
                        data = null;
                    }
                }
 */               
                if (r == -1) {
                    r = this.addEmptyRowNoDefault();
                    lastLoadedRow = r;
                }
                CellBase base = (CellBase) this.getValueAt(r, i);
                if (data != null && !data.equals("")) {
                    base.setValue(data);
                    base.setModified(false);
                    if (column.isKey()) {
                        base.setEditable(false);
                    }
                }
            }

            // check the record by filter - accept if accepted by any of the filters
            boolean accept = true;
            
                for (int i = 0; i < n; ++i) {
                    Column column = config.getColumn(i);
                    CellBase base = (CellBase) this.getValueAt(r, i);
                    for (Filter filter : filters){
                        int result = filter.accept(column, base);
                        if (result == 0){
                            continue;
                        } else {
                            if (result == 1){
                                accept = true;
                                break;
                            } else{
                                accept = false;
                            }
                            
                        }

                }
            }
            if (accept) {
                String ks = keyColumns(r);
                if (ks != null){
                    primaryKeys.add(r, ks);  // save the sql fragment identifying the primary key of the row
                    //           this.clearChanges(r);
                    this.clearChanges(r);
                }
            } else {
                this.removeRow(r);  // row did not pass filter
                --lastLoadedRow;
            }
                        
            // update appropriate columns
            for (int i = 0; i < n; ++i) {
                Column column = config.getColumn(i);
                if (column.isUpdateAfterLoad()){
                    CellBase base = (CellBase) this.getValueAt(r, i);
                    base.update();
                }
            }
        }
        duringLoad = false;
        return rs;
    }

    public boolean isLoading() {
        return duringLoad;
//        return false;
    }
    // update the backing DB with the rows in this spreadsheet

    public void updateDb() throws Exception {
        // check the primary key before saving any records
        for (int r = 0; r < this.getRowCount(); ++r) {
            if (this.keyColumns(r) == null){
                JOptionPane.showMessageDialog(LabMan.labMan, "There is missing data, cannot save the records");
                return;
            }
        }
        for (int r = 0; r < this.getRowCount(); ++r) {
            if (r <= lastLoadedRow) {
                updateRow(r);

            } else {
                addRowToDB(r);
            }
        }
        lastLoadedRow = this.getRowCount() - 1;
    }
    // update the given row in the backing DB

    public void updateRow(int r) throws Exception {
        // update the db record
        String keyString=null;
        try {
            keyString = this.primaryKeys.get(r);
        } catch (Exception exc){
            int iuasfduis=0;
        
        }
//System.out.println(keyString);
        if (keyString != null) {
            String changes = changedColumns(r);
//System.out.println(changes);            
            if (!changes.equals("")) {
                String sql = null;
                try {
                    sql = String.format("Update %s set %s where %s", config.getDbTable(), changes, keyString);
//System.out.println(sql);
                    MySql.getMySql().execute(sql);
                    this.clearChanges(r);
                } catch (Exception exc) {
                    JOptionPane.showMessageDialog(LabMan.labMan,
                            String.format("Error saving to database table: %s using sql statement:\n%s", config.getDbTable(), sql));
                    exc.printStackTrace();
                }
            }
        }
        int n = config.getColumnCount();
        for (int c = 0; c < n; ++c) {
            CellBase base = (CellBase) this.getValueAt(r, c);
            base.updateDB();
        }
    }
    // determine if the primary key in the given row is unique

    public boolean isRowUnique(int r) throws Exception {
        // check the database for a record that matches
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            int c = config.getDbColumn(key);
            CellBase base = null;
            try {
                base = (CellBase) this.getValueAt(r, c);
            } catch (Exception exc) {
                exc.printStackTrace();
            }
            String value;
            value = base.getValueAsString();
            this.primaryKeySelect.setString(+1, value);

        }
        ResultSet rs = this.primaryKeySelect.executeQuery();
        if (rs.next()) {
            return false;  // already a record in database, row is not unique
        }
/*        
        // check all the unsaved records
        if (lastLoadedRow == -1) {
            return true;
        }
*/
        String keyValue = keyColumns(r);
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (i != r) {
                String existingKeyValue = keyColumns(i);
                if (keyValue.equals(existingKeyValue)) {
                    return false;
                }
            }
        }
        return true;
    }

    // check to see that this model can be saved to the backing db table
    // makes sure all the primary keys have values
    public boolean isSaveable() {
        // check the added rows for complete primary key
        if (lastLoadedRow == -1) {
            return true;
        }
        for (int r = lastLoadedRow; r < this.getRowCount(); ++r) {
            if (keyColumns(r) == null) {
                return false;
            }
        }
        return true;
    }
    // build the sql fragment that identifies the db record from primary key
    // return null if any data to make the key is missing

    private String keyColumns(int r) {
        StringBuilder builder = new StringBuilder();
        int n = config.getColumnCount();
        boolean first = true;
        for (int i = 0; i < keys.size(); ++i) {
            int c = config.getDbColumn(keys.get(i));
            if (c == -1) {
                return null;
            }
 //           System.out.println( keys.get(i));
            Column column = config.getColumn(c);
            CellBase base = null;
            try {
                base = (CellBase) this.getValueAt(r, c);
            } catch (Exception exc) {
                exc.printStackTrace();
            }
            String value = base.getValueAsString();
            if (value.equals("")) return null;  // abort on missing data
            if (!first) {
                builder.append(" and ");
            }
            builder.append(column.getDbColumn());
            builder.append("=\'");
            builder.append(value);
            builder.append("\'");
            first = false;
        }
        return builder.toString();
    }
    // build the sql fragment for the changed data values in the given row

    private String changedColumns(int r) {
        StringBuilder builder = new StringBuilder();
        int n = config.getColumnCount();
        boolean first = true;
        for (int c = 0; c < n; ++c) {
            Column column = config.getColumn(c);
            if (!column.isSelectColumn()) {
                String dbCol = column.getDbColumn();
                if (dbCol != null && !dbCol.equals("")) {
                    CellBase base = (CellBase) this.getValueAt(r, c);
                    if (base.hasChanged()) {
                        if (!first) {
                            builder.append(" , ");
                        }
                        if (base instanceof IntegerCell || base instanceof DoubleCell) {
                            builder.append(column.getDbColumn());
                            String iv = base.getAsSqlString();
                            if (!iv.equals("")){
                                builder.append("=");
                                builder.append(iv);
                            } else {
                                builder.append(" = null ");
                            }
                        } 
                        else if (base instanceof BooleanCell) {
                            builder.append(column.getDbColumn());
                            builder.append("=");
                            builder.append(base.getAsSqlString());
                        } else if (base instanceof DateCell) {
                            String dateStr = base.getAsSqlString();
                            if (!dateStr.equals("")) {
                                builder.append(column.getDbColumn());
                                builder.append("=\'");
                                builder.append(dateStr);
                                builder.append("\'");
                            } else {
                                builder.append(column.getDbColumn());
                                builder.append(" = null ");
                            }
                        } else {
                            builder.append(column.getDbColumn());
                            builder.append("=\'");
                            builder.append(base.getAsSqlString());
                            builder.append("\'");
                        }
                        first = false;
                    }
                }
            }
        }
        return builder.toString();
    }

    public void addRowToDB(int r) throws Exception {
        if (keyColumns(r) == null) {
            return;  // don't add this row if the key is missing data
        }
        StringBuilder columnBuilder = new StringBuilder();
        StringBuilder valueBuilder = new StringBuilder();
        int n = config.getColumnCount();
        boolean first = true;
        for (int c = 0; c < n; ++c) {
            CellBase base = (CellBase) this.getValueAt(r, c);
            Column column = config.getColumn(c);
            String dbCol = column.getDbColumn();
            if (dbCol != null && column.getSelectColumn()==null) {

                String value = base.getValueAsString();
                if (value != null && !value.equals("")) {
                    if (!first) {
                        columnBuilder.append(",");
                        valueBuilder.append(",");
                    }
                    columnBuilder.append(dbCol);
                    if (base.getValue() instanceof Boolean) {
                        valueBuilder.append(value);
                    } else if (base.getValue() instanceof Date) {
                        valueBuilder.append('\'');
                        valueBuilder.append(((DateCell)base).getAsSqlString());
                        valueBuilder.append('\'');
                    } else {
                        valueBuilder.append('\'');
                        String newValue = replaceAllQuotes(value);
                        if (value.contains("\'")) {
                            int asjdf = 0;
                        }
                        valueBuilder.append(newValue);
                        valueBuilder.append('\'');
                    }
                    first = false;
                }
            } else {
                base.updateDB();
            }
        }
        if (!first) {
            String sql = String.format("Insert into %s (%s) values(%s)", config.getDbTable(), columnBuilder.toString(), valueBuilder.toString());
            MySql.getMySql().execute(sql);
            primaryKeys.add(r, keyColumns(r));
            clearChanges(r);
        }

    }

    public SpreadSheet getConfig() {
        return config;
    }
    // determine if any of the data in the spreadsheet has changed

    public boolean hasChanged() {
        int n = this.getRowCount();
        int nCol = this.getColumnCount();
        for (int r = 0; r < n; ++r) {
//            String str = this.changedColumns(r);
            //           if (!str.equals("")) return true;
            for (int c = 0; c < nCol; ++c) {
                CellBase base = (CellBase) this.getValueAt(r, c);
                if (base.hasChanged()) {
                    return true;
                }
            }
        }
        return false;
    }

    public void clearChanges(int row) {
        int n = this.getColumnCount();
        for (int c = 0; c < n; ++c) {
            CellBase base = (CellBase) this.getValueAt(row, c);
            base.setModified(false);
        }
    }

    private String replaceAllQuotes(String in) {
        int start = 0;
        StringBuilder builder = new StringBuilder();
        int index = in.indexOf('\'', start);
        while (index != -1) {
            builder.append(String.format("%s\\\'", in.substring(start, index)));
            start = index + 1;
            index = in.indexOf('\'', start);
        }
        builder.append(in.substring(start));
        return builder.toString();
    }

    public String getViewTitle() {
        return config.getTitle();
    }

    public Class getColumnClass(int i) {
        return config.getColumn(i).getDataClass();
    }

    public int findColumn(String head) {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (head.equals(this.getColumnName(i))) {
                return i;
            }
        }
        return -1;
    }

    public boolean hasData(int row, String[] columns) {
        for (String column : columns) {
            if (!hasData(row, column)) {
                return false;
            }
        }
        return true;
    }

    public boolean hasData(int row, String colum) {
        int c = config.getColumn(colum);
        CellBase base = (CellBase) this.getValueAt(row, c);
        String value = base.getValueAsString();
        return !value.equals("");
    }

    public CellBase getLabeledCell(String label) {
        return cells.get(label);
    }
    public ArrayList<String> getKeys(){
        return keys;
    }
    PreparedStatement primaryKeySelect;
    boolean duringLoad = false;
    ArrayList<String> keys = new ArrayList<String>();  // the list of primary keys in the DB table backing this spreadsheet model
    ArrayList<String> primaryKeys;  // the primary key values for each row - used for  updating the rows in the backing db
    int lastLoadedRow;  // the last row loaded from the database
    SpreadSheet config;
    HashMap<String, CellBase> cells = new HashMap<String, CellBase>();  // individual cells of data associated with this model
    static SimpleDateFormat sqlDateFormat = new SimpleDateFormat("yyyy-MM-dd");
}
