/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.rhwlab.LMS.FileListCell;

/**
 *
 * @author gevirl
 */
public class MultipleFileChoiceEditor extends AbstractCellEditor implements TableCellEditor,ActionListener{

    public MultipleFileChoiceEditor(){
        button = new JButton("Files");
        chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
 //       chooser.setCurrentDirectory(new File("/nfs/waterston/andrea"));
        button.addActionListener(this);        
    }
    public Object getCellEditorValue(){

        return cellObj;
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        if (value instanceof FileListCell){
            cellObj = (FileListCell)value;
            File[] files = (File[])cellObj.getValue();
            chooser.setSelectedFiles(files);
            button.setText(cellObj.getValueAsString());
        }
        return button;
    } 
     public boolean stopCellEditing() {
        if (ret == JFileChooser.APPROVE_OPTION){
            File[] files = chooser.getSelectedFiles();
            cellObj.setValue(files);
        } 
        return super.stopCellEditing();
     } 
    CellBase cellObj;  
    JButton button;
    JFileChooser chooser;
    int ret;

    @Override
    public void actionPerformed(ActionEvent e) {
        ret = chooser.showDialog(button, "Accept");
    }
}
