/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author gevirl
 */
public class ListEditor extends AbstractCellEditor implements TableCellEditor,ItemListener{
    public ListEditor(){
    }

    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        
        cellObj = (CellBase)value;
        if (!cellObj.isEditable()) return null;
        
        Object o = cellObj.getValue();
        if (cellObj.getValue() instanceof String){
            initialValue = cellObj.getValueAsString();
            field= new JTextField(initialValue);
            box = null;
            return field;
        } else if (cellObj.getValue() instanceof DefaultComboBoxModel) {
            initialValue = cellObj.getValueAsString();
            box = new JComboBox((DefaultComboBoxModel)cellObj.getValue());
            box.setEditable(false);
            box.addItemListener(this);
            field = null;
            return box;
        
        }else {
            System.out.println("Unknown class in ListEditor");
            System.exit(0);
        }
        
        return null;
    } 
    
     public Object getCellEditorValue() {
       cellObj.unlock();
        return cellObj;
    }

     public boolean stopCellEditing() {
         if (field == null){
             String newValue = cellObj.getValueAsString();
             if (!newValue.equals(initialValue)){
                 if (!cellObj.validate(newValue)){
                     cellObj.setValue(this.initialValue);
                     return false;
                 }
                 cellObj.cellHasBeenChanged();
                 cellObj.unlock();
             }
         }else {
             String newValue = field.getText().trim();
             if (!newValue.equals(initialValue)){
                 cellObj.setValue(newValue);
                        cellObj.unlock();
             }
         }
         return super.stopCellEditing();
     }
     
     CellBase cellObj;
     JTextField field;
     JComboBox box;
     DefaultComboBoxModel boxModel;
     
     String initialValue;

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange()==ItemEvent.SELECTED){
              String newValue = cellObj.getValueAsString();
//             if (!newValue.equals(initialValue)){
                 cellObj.cellHasBeenChanged();
                 cellObj.unlock();
                 stopCellEditing();
 //            }           
        }
    }
}
