/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import org.rhwlab.json.PrettyWriter;

/**
 *
 * @author gevirl
 */
public class JsonDisplay extends AbstractCellEditor implements TableCellEditor{
    public JsonDisplay(){
        button = new JButton();
        dialog = new JDialog();
        dialog.setSize(new Dimension(500,300));
        
        Container content = dialog.getContentPane();
        area = new JTextArea();
        area.setEditable(false);
        area.setLineWrap(true);
        
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(area);
        content.add(scroll);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });        
    }
    public Object getCellEditorValue(){
        return cellObj;
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        String cellString = cellObj.getValueAsString();
        
        // convert string to pretty json
        PrettyWriter pretty = new PrettyWriter();
        BufferedReader bufReader = new BufferedReader(new StringReader(cellString));
        try {
            String line = bufReader.readLine();
            while (line != null){
                pretty.write(line);
                line = bufReader.readLine();
            }
        } catch (Exception exc){
            exc.printStackTrace();
        }
        
        cellString = pretty.getPrettyJson();
        button.setText(cellString);
        area.setText(cellString);
        
        if (value instanceof Highlightable){
            List<Highlight> highs = ((Highlightable)value).getHighlights();
            if (highs!=null){
                for (Highlight high : highs){
                    Highlighter lighter = area.getHighlighter();
                    try {
                        lighter.addHighlight(high.getStart(),high.getEnd(),high.getPainter());
                    } catch (BadLocationException exc){}
                }
            }
        }
        return button;
    } 
  
    JTextArea area;
    JDialog dialog;
    CellBase cellObj;  
    JButton button;
}
