/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author gevirl
 */
public class FileChoiceEditor extends AbstractCellEditor implements TableCellEditor,ActionListener{

    public FileChoiceEditor(){
        
        button = new JButton();
        chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                return f.getName().startsWith("N2_EE_50");
            }

            @Override
            public String getDescription() {
                return "N2_EE_50*";
            }
        });        
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                return f.getPath().endsWith(".txt.gz");
            }

            @Override
            public String getDescription() {
                return "*.txt.gz";
            }
        });
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                return f.getPath().endsWith(".txt.gz") && f.getPath().contains("_1_");
            }

            @Override
            public String getDescription() {
                return "*_1_*.txt.gz";
            }
        });    
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                return f.getPath().endsWith(".txt.gz") && f.getPath().contains("_2_");
            }

            @Override
            public String getDescription() {
                return "*_2_*.txt.gz";
            }
        });    
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                Pattern p = Pattern.compile(".+_\\d_1_.+gz");
                Matcher m = p.matcher(f.getName());
                return m.matches();
            }

            @Override
            public String getDescription() {
                return "*_?_1_*.txt.gz";
            }
        });  
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                Pattern p = Pattern.compile(".+_\\d_2_.+gz");
                Matcher m = p.matcher(f.getName());
                return m.matches();
            }

            @Override
            public String getDescription() {
                return "*_?_2_*.txt.gz";
            }
        });        
        chooser.setMultiSelectionEnabled(true);
 //       chooser.setCurrentDirectory(new File("/nfs/waterston/andrea"));
        button.addActionListener(this);        
    }
    public Object getCellEditorValue(){

        return cellObj;
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        String cellString = cellObj.getValueAsString();
        if (!cellString.equals("")){
            button.setText(cellString);
            String[] fileNames = cellString.split(",");
            File[] files = new File[fileNames.length];
            for (int i=0 ; i<files.length ; ++i){
                files[i] = new File(fileNames[i]);
            }
            chooser.setSelectedFiles(files);
        }
        return button;
    } 
     public boolean stopCellEditing() {

        return super.stopCellEditing();
     } 
    CellBase cellObj;  
    JButton button;
    JFileChooser chooser;
    int ret;

    @Override
    public void actionPerformed(ActionEvent e) {
        ret = chooser.showDialog(button, "Accept");
        if (ret == JFileChooser.APPROVE_OPTION){
            String text = chooser.getSelectedFile().getPath();
            File[] files = chooser.getSelectedFiles();
            StringBuilder builder = new StringBuilder();
            builder.append(files[0].getPath());
            for (int i=1 ; i<files.length ; ++i){
                builder.append(",");
                builder.append(files[i].getPath());
            }
            cellObj.setValue(builder.toString());
            button.setText(text);
        } 
    }
}
