/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author gevirl
 */
public class DirectoryChoiceEditor extends AbstractCellEditor implements TableCellEditor,ActionListener{

    public DirectoryChoiceEditor(){
        button = new JButton();
        chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        button.addActionListener(this);        
    }
    public Object getCellEditorValue(){

        return cellObj;
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        String cellString = cellObj.getValueAsString();
        button.setText(cellString);
        chooser.setSelectedFile(new File(cellString));

        return button;
    } 
     public boolean stopCellEditing() {
        if (ret == JFileChooser.APPROVE_OPTION){
            String text = chooser.getSelectedFile().getPath();
            cellObj.setValue(text);
        } 
        return super.stopCellEditing();
     } 
    CellBase cellObj;  
    JButton button;
    JFileChooser chooser;
    int ret;

    @Override
    public void actionPerformed(ActionEvent e) {
        ret = chooser.showDialog(button, "Accept");
    }
}
