/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.rhwlab.LMS.DateCell;
/**
 *
 * @author gevirl
 */
public class DateEditorSave extends DefaultCellEditor {
    public DateEditorSave() {
        super(new JTextField());

    }

    //Override to invoke setValue on the formatted text field.
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        String cellString = ((DateCell)cellObj).getValueAsString();
        JTextField textField = (JTextField)super.getTableCellEditorComponent(table, cellString, isSelected, row, column);
        return textField;
    }
     public Object getCellEditorValue() {
       JTextField textField = (JTextField)getComponent();
       String text = textField.getText().trim();
       String oldText = cellObj.getValueAsString();
       if (!text.equals(oldText)){
            cellObj.setValue(text);
            cellObj.unlock();
       }
       return cellObj;
    }
     public boolean stopCellEditing() {
         JTextField textField = (JTextField)getComponent();
         String newValue = textField.getText().trim();
         if (cellObj.validate(newValue)){
             return super.stopCellEditing();

         } else {
             if (revert()){
                 textField.setText(cellObj.getValueAsString());
                 return false; // go back to editing
             }
         }
         return false;
     }

     private boolean revert(){
         JTextField textField = (JTextField)getComponent();
        Toolkit.getDefaultToolkit().beep();
        Object[] options = {"Edit",
                            "Revert"};
        int answer = JOptionPane.showOptionDialog(
            SwingUtilities.getWindowAncestor(textField),
            "The value must be a date in format dd-MMM-yy\n "
            + "You can either continue editing "
            + "or revert to the last valid value.",
            "Invalid Text Entered",
            JOptionPane.YES_NO_OPTION,
            JOptionPane.ERROR_MESSAGE,
            null,
            options,
            options[1]);
	    
        if (answer == 1) { //Revert!
	    return true;
        }
	return false;         
     }    
    CellBase cellObj;
}
