/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.config.Column;

/**
 *
 * @author gevirl
 */
abstract public class CellBase  implements ChangeListener,Comparable  {
    public CellBase(){
        
    }
    public CellBase(Object value){
        this.value = value;        
    }
    public void update(){
        
    }
    // get all the columns that notify this cell of changes
    public List<Column> getNotifiers(){
        Column column = model.config.getColumn(col);
        return column.getNotifiers();
    }
    // tell all the listeners there has been a change in this cell value
    public void notifyListeners(ChangeEvent event){
        if (model == null) return;
        for (ChangeListener listen : listeners){
//           listen.stateChanged(event);
            
            if (model.isLoading()){
                // do not notify columns that are going to be loaded from the db
                CellBase base = (CellBase)listen;
                if (!base.isDBColumn || base.notifyOnLoad){
                    listen.stateChanged(event);
                }
            } else {
                listen.stateChanged(event);
            }
        }
    }
    public void addListener(ChangeListener listener){
        listeners.add(listener);
    }
    public void addInput(String name,CellBase input){
        inputs.put(name,input);
    }
    public Object getValue(){
        return this.value;
    }

    public String toString(){
        return getValueAsString();
    }    
    public void setModified(boolean mod){
        modified = mod;
    }
    public boolean setValue(Object obj){
     
        return setValue(obj,true);
    }
    public boolean setValue(Object obj,boolean notify){
        this.value = obj;
        this.modified = true;
        if (notify){
            cellHasBeenChanged();
        }
        return true;
    }
    public void cellHasBeenChanged(){
        locked = true;
        this.modified = true;
        notifyListeners(new ChangeEvent(this));
        if (model != null)
            model.fireTableCellUpdated(row, col);     
        this.unlock();
    }
    // unlock this cell and all it's listeners
    public void unlock(){
        if (!locked) return;
        locked=false;
        for (ChangeListener listen : listeners){
            if (listen instanceof CellBase){
                CellBase base = (CellBase)listen;
                base.unlock();
            }
        }
    }
    abstract public boolean validate(String newValue);
    abstract public String getValueAsString();

    public String getAsSqlString(){
        return this.getValueAsString();
    }

    public void setModel(SpreadSheetModel model){
        this.model = model;
    }
    public SpreadSheetModel getModel(){
        return this.model;
    }
    public void setRow(int row){
        this.row = row;
    }
    public void setColumn(int col){
        this.col = col;
    }
    public String[] getInputColumns(){
        return inputs.keySet().toArray(new String[0]);
    }
    public boolean hasChanged(){
        return modified;
    }
    public int getRow(){
        return row;
    }
    // parameters have not been implemented
    public void setParameter(String name,String value){
        
    }
    public boolean isEditable(){
        return editable;
    }
    public void setEditable(boolean edit){
        this.editable = edit;
    }
    public int getColumn(){
        return col;
    }
    public void setDBColumn(boolean b){
        isDBColumn = b;
    }
    public boolean isDBColumn(){
        return isDBColumn;
    }
    public void setNotifyOnLoad(boolean b){
        this.notifyOnLoad = b;
    }
    public boolean notfiOnLoad(){
        return this.notifyOnLoad;
    }
    public String getColumnHeader(){
        Column column = model.config.getColumn(col);
        return column.getHeader();
    }
    public String getDBColumn(){
        Column column = model.config.getColumn(col);
        return column.getDbColumn();
    }
    public void setDefault(Object def) {
        this.setValue(def);
    }
    public String getDBTable(){
        return model.config.getDbTable();
    }
    
    
    // this should be overriden in any cell type that maintains it's value independently in the DB
    // a false return means the method did not update the database
    // a true return means the cell did perform a db update of some kind
    public boolean updateDB() throws Exception{
        return false;
    }
    
    public void setValidate(boolean v){
        validate = v;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        CellBase source = (CellBase)ce.getSource();
        Column column = model.getConfig().getColumn(col);
        // is this a select column (built by selecting from another table)
        String select = column.getSelect();
        if (select != null) {
            String sql = String.format(select, source.getValueAsString());
            try {
                ResultSet rs1 = MySql.getMySql().execute(sql);
                if (rs1.next()) {
                    String data = rs1.getString(1);
                    this.setValue(data);
                } 
            } catch(Exception exc){
                exc.printStackTrace();
            }
        } else {
            this.setValue(source.getValue(), false);
        }       
    }
  
    public String getDefaultValue(){
        Column column = model.getConfig().getColumn(col);
        return column.getDefault();
    }
    public JsonObjectBuilder toJsonBuilder(){
        JsonObjectBuilder build = Json.createObjectBuilder();
        build.add(this.getColumnHeader(), this.getValueAsString());
        for (String key : inputs.keySet()){
            build.add(key, inputs.get(key).getValueAsString());
        }
        
        return build;
    }
    protected boolean validate = true;
    protected Object value;
    protected boolean locked = false;
    protected boolean modified = false;
    protected boolean editable = true;
    protected boolean isDBColumn = false;
    protected boolean notifyOnLoad = false;
    protected HashMap<String,CellBase> inputs = new HashMap<String,CellBase>();
    ArrayList<ChangeListener> listeners = new ArrayList<ChangeListener>();
    protected SpreadSheetModel model;
    protected SpreadSheetPanel panel;  // a panel that is notified when this cell 
    int row;
    int col;
    
}
