/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.wormRNA;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class SampleID extends TextCell {
    public SampleID(){
        this("");
    }
    public SampleID(String id){
        super(id);
        inputs.put("StrainID", null);
        inputs.put("Stage", null);
        inputs.put("SampleNumber", null);
    }
    public void stateChanged(ChangeEvent ce) {
        CellBase base  = (CellBase)inputs.get("StrainID");
        if (base != null){
            String strainId = base.getValueAsString();
            base = (CellBase)inputs.get("Stage");
            if (base != null){
                String stage = base.getValueAsString();
                base = (CellBase)inputs.get("SampleNumber");
                if (base != null){
                    String number = base.getValueAsString();
                    if (!strainId.equals("") && !stage.equals("") && !number.equals("")){
                        this.setValue(String.format("%s_%s_%s", strainId,stage,number));
                    }
                }                
            }

        }
    }
}