/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.models.WormRNASampleModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.TrackingPanel;
import org.rhwlab.spreadsheet.config.SpreadSheet;
import org.rhwlab.spreadsheet.config.Transfer;

/**
 *
 * @author gevirl
 */
public class WormRNASamplePanel extends TrackingPanel {
    public WormRNASamplePanel(){
        super(false,inits);
        buildMenu();
    }
    
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("WormRNASample");  
        
        JMenuItem groupRecords = new JMenuItem("Group Selected Samples");
        groupRecords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    addDataSet();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        menu.add(groupRecords);
        JMenuItem addDNA = new TransferMenuItem("To cDNA","cDNA",WormRNASamplePanel.this);
        menu.add(addDNA);
        
        JMenuItem linkItem = new JMenuItem("Link Selected Samples");  // linking control and deletion samples
        linkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                link();
            }
        });
        menu.add(linkItem);
        
    } 
    
    public void addDataSet()throws Exception {
        int[] rows = WormRNASamplePanel.this.getConvertedSelectedRows();
        if (rows.length==0) return;
        
        // check all strains are the same
        String dsStrain = null;
        for (int row : rows){
            String strain = this.getValue(row,"StrainID");
            if (dsStrain == null) {
                dsStrain = strain;
            }else {
                if (!dsStrain.equals(strain)){
                    // error
                    JOptionPane.showMessageDialog(this, "All strains need to be the same in a group");
                    return;
                }
            }
        }
        
        WormRNASampleModel model = (WormRNASampleModel)this.getModel();
        int dsNo = model.nextDataSet(dsStrain,rows[0]);
        String dataSet = String.format("%s_DS%d",dsStrain,dsNo);
        for (int row : rows){
            this.getModel().setValue(row,"DataSet",dataSet, true);
            this.getModel().setValue(row,"DataSetNo", String.format("%d",dsNo), true);
        }
        
        // make the dataset directories
        File knockdownDir = new File(knockDownDirectoryName);
        File knockMiSeqDir = new File(knockdownDir,miSeqDirectoryName);  
        File knockHiSeqDir = new File(knockdownDir,hiSeqDirectoryName); 
        File dataSetDir = new File(knockMiSeqDir,dataSet);
        dataSetDir.mkdir();
        dataSetDir.setReadable(true, false);
        dataSetDir.setWritable(true, false); 
        dataSetDir.setExecutable(true, false);  
        dataSetDir = new File(knockHiSeqDir,dataSet);
        dataSetDir.mkdir();
        dataSetDir.setReadable(true, false);
        dataSetDir.setWritable(true, false);
        dataSetDir.setExecutable(true, false); 
        
        // make a new DataSet record
        SpreadSheet sheet = this.getConfig();
        Transfer transfer = sheet.getTransfer("DataSet");
        String destClass = transfer.getPanelClass();
        SpreadSheetPanel dest = sheet.getPanel(destClass);
        LinkedHashMap<String,String> pairsMap = transfer.getPairings();
        this.addToMappedPanel(rows[0],dest,pairsMap,transfer.getRequiredColumns());
    }
    private void link(){
        int[] rows = this.getConvertedSelectedRows();
        if (rows.length!=2){
            JOptionPane.showMessageDialog(this, "Two rows must be selected for linking");
            return;
        } 
        String gene0 = this.getValue(rows[0],"TargetGene");
        String gene1 = this.getValue(rows[1],"TargetGene");
        
        if ( (gene0.equals("")&&gene1.equals("")) || (!gene0.equals("")&&!gene1.equals("")) ){
            JOptionPane.showMessageDialog(this, "There must be one control and one non-control for linking");
            return;            
        }
        
        if (gene0.equals("")){
            link(rows[0],rows[1]);
        } else {
            link(rows[1],rows[0]);
        }
    }
    private void link(int ctl,int non){
        String control = this.getValue(ctl,"SampleID");
        this.getModel().setValue(non,"Control",control, true);

    }
    private void link(File baseDir,String data,String control){
        File dataDir = new File(baseDir,data);
        File ctlDir = new File(baseDir,control);
        File linkFile = new File(dataDir,"control");
        if (linkFile.exists()){
            linkFile.delete();
        }
        String cmd =String.format("ln -s %s %s",ctlDir.getPath(),linkFile.getPath());
        linkFile.setExecutable(true, false);
        linkFile.setReadable(true, false);
        linkFile.setWritable(true, false);
        try {
            Runtime.getRuntime().exec(cmd);
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }    
    static File getMiSeq(){
        return new File(new File(knockDownDirectoryName),miSeqDirectoryName);
    }
    static File getHiSeq(){
        return new File(new File(knockDownDirectoryName),hiSeqDirectoryName);
    }
    static String[] inits = {"Pending"};  
    public static String knockDownDirectoryName = "/net/waterston/vol9/knockdown";
    public static String miSeqDirectoryName = "MiSeq";
    public static String hiSeqDirectoryName = "HiSeq";
}
