/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import org.rhwlab.DAG.views.GeneTablePanel;
import org.rhwlab.DAG.views.UnifiedResultFrame;
import org.rhwlab.LMS.RNASeq.Finisher;
import org.rhwlab.LMS.RNASeq.TimeSeriesMap;
import org.rhwlab.LMS.RNASeq.UnificationID;
import org.rhwlab.LMS.dialogs.AddConditionDialog;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class UnificationPanel extends TrackingPanel implements ActionListener {

    public UnificationPanel() {
        super(false, inits);
        buildMenu();

    }

    public void buildMenu() {

        super.getMenu();
        menu.setText("Unification");

        JMenuItem train = new JMenuItem(trainItem);
        train.addActionListener(this);
        menu.add(train);
        
        JMenuItem decon = new JMenuItem(deconvolveItem);
        decon.addActionListener(this);
        menu.add(decon);        

        JMenuItem norm = new JMenuItem(normalize);
        norm.addActionListener(this);
        menu.add(norm); 
        
        JMenuItem view  = new JMenuItem(viewItem);
        view.addActionListener(this);
        menu.add(view);        
        
        TransferMenuItem copyRecs = new TransferMenuItem("Copy Record(s)","Unification",UnificationPanel.this);
        menu.add(copyRecs);      
        
        JMenuItem fin = new JMenuItem(finish);
        fin.addActionListener(this);
//        menu.add(fin); 
        
        JMenuItem errItem  = new JMenuItem(err);
        errItem.addActionListener(this);
        menu.add(errItem);        
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int[] rows = this.getConvertedSelectedRows();
            if (e.getActionCommand().equals(trainItem)) {

                int timeSeriesColumn = this.getConfig().getColumn("TimeSeries");
                for (int i = 0; i < rows.length; ++i) {
                    TimeSeriesMap map = (TimeSeriesMap) this.getModel().getValueAt(rows[i], timeSeriesColumn);
                    map.submit();
                    this.updateDB();
                    Thread.sleep(500);                    
                }

            }
            else if (e.getActionCommand().equals(deconvolveItem)) {

                int timeSeriesColumn = this.getConfig().getColumn("TimeSeries");
                for (int i = 0; i < rows.length; ++i) {
                    TimeSeriesMap map = (TimeSeriesMap) this.getModel().getValueAt(rows[i], timeSeriesColumn);
                    map.submitDeconvolve();
                    this.updateDB();
                    Thread.sleep(500);                    
                }

            }    
            else if (e.getActionCommand().equals(normalize)) {

                int timeSeriesColumn = this.getConfig().getColumn("TimeSeries");
                for (int i = 0; i < rows.length; ++i) {
                    TimeSeriesMap map = (TimeSeriesMap) this.getModel().getValueAt(rows[i], timeSeriesColumn);
                    map.submitNormalize();
                    this.updateDB();
                    Thread.sleep(500);                    
                }

            }  
            else if (e.getActionCommand().equals(viewItem)) {

                int timeSeriesColumn = this.getConfig().getColumn("TimeSeries");
                TimeSeriesMap map = (TimeSeriesMap) this.getModel().getValueAt(rows[0], timeSeriesColumn);
                UnifiedResultFrame frame = new UnifiedResultFrame();
                frame.setStudies(map.getStudy());
                GeneTablePanel panel = new GeneTablePanel();
                // build a gene list
                TreeSet<String> geneList = new TreeSet<>();
                File uniDir = new File(map.getDirectory());
                String[] uniFiles = uniDir.list();
                for (String uniFile : uniFiles){
                    if (uniFile.startsWith("Genes.")){
                        File uni= new File(uniDir,uniFile);
                        BufferedReader reader = new BufferedReader(new FileReader(uni));
                        String line = reader.readLine();
                        while(line != null){
                            geneList.add(line);
                            line = reader.readLine();
                        }
                        reader.close();
                    }
                }
                panel.setGeneList(geneList);
                panel.init();
                frame.setGeneTable(panel);
                frame.init();
                frame.setVisible(true);
            }             
            else if (e.getActionCommand().equals(finish)){
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    Finisher finish = new Finisher(this.getValue(rows[i],"AnalysisID"),"Analysis");
                    finish.setDir(this.getValue(rows[i],"Directory"));
                    finish.init();
                    finish.run();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
            
        }
            else if (e.getActionCommand().equals(err)){
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    int idColumn = this.getConfig().getColumn("UnificationID");
                    UnificationID id = (UnificationID) this.getModel().getValueAt(rows[0],idColumn);
                    double error = id.rmsError();
                    this.getModel().setValue(rows[i],"rmsError", Double.toString(error), true);

                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
            
        }            
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }


    AddConditionDialog conditionDialog;
    static String trainItem = "Submit Training";
    static String deconvolveItem = "Submit Deconvolution";
    static String normalize = "Submit Normalization";
    static String viewItem = "View Results";
    static String finish = "Run finisher";
    static String err = "Compute error";
    static String[] inits = {"Pending"};

}
