/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.dialogs.AddUnificationDialog;
import org.rhwlab.LMS.dialogs.ExportExpressionValuesDialog;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class TimeSeriesPanel extends TrackingPanel  implements ActionListener{
    public TimeSeriesPanel(){
        super(false,inits);
        buildMenu();
        
    }
    
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("Time Series");    
        
        JMenuItem express = new JMenuItem(expressionItem);
        express.addActionListener(this);
        menu.add(express);   
        
        JMenuItem warp = new TransferMenuItem("To TimeWarping","TimeWarp",TimeSeriesPanel.this);
        menu.add(warp); 
        
        JMenuItem buildFileItem = new JMenuItem(dataFile);
        buildFileItem.addActionListener(this);
        menu.add(buildFileItem);         
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();

        if (e.getActionCommand().equals(expressionItem)){
            if (rows.length < 2){
                JOptionPane.showMessageDialog(this,"Select at least 2 time series to unify");
                return;
            }            
            if (this.uniDialog==null){
               this.uniDialog = new AddUnificationDialog(this);
            }
            this.uniDialog.setVisible(true);
            this.uniDialog.init();
        } 
        else if (e.getActionCommand().equals(dataFile)){
            if (rows.length < 1){
                JOptionPane.showMessageDialog(this,"Select at least one time series");
                return;
            }             
            if (fileDialog == null){
                this.fileDialog = new ExportExpressionValuesDialog(this);
            }
            this.fileDialog.init();
            this.fileDialog.setVisible(true);
        }
    }
    AddUnificationDialog uniDialog;
    ExportExpressionValuesDialog fileDialog;
    static String expressionItem = "Define Unification";
    static String[] inits = {"Pending"};
    static String dataFile = "Export Expression Values";
}

