/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.LMS.models.StrainModel;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class StrainPanel extends TrackingPanel {
    public StrainPanel(){
        super(true,inits);
        buildMenu();
    }
   
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("Strains"); 
        
        JMenuItem cross = new TransferMenuItem("To Crossing","Cross",StrainPanel.this);
        menu.add(cross); 
        JMenuItem freeze = new TransferMenuItem("To Freezing","Freeze",StrainPanel.this);
        menu.add(freeze);     
        JMenuItem screen = new TransferMenuItem("To Screening","Screen",StrainPanel.this);
        menu.add(screen);
        JMenuItem ship = new TransferMenuItem("To Shipping","Ship",StrainPanel.this);
        menu.add(ship); 
        JMenuItem image = new TransferMenuItem("To Imaging","Imaging",StrainPanel.this);
        menu.add(image);  
        JMenuItem pcr = new TransferMenuItem("To SingleWormPCR","PCR",StrainPanel.this);
        menu.add(pcr);         
    } 
    public void appendLineagingLine(String strain,String line) throws Exception {
        StrainModel strainModel = (StrainModel)this.getModel();
        int row = strainModel.findRecordContainingValue("StrainID", strain, 0);
        if (row != -1){
            int genotypeColumn = strainModel.findColumn("Genotype");
            int alleleColumn = strainModel.findColumn("LineageAllele");
            CellBase geneotypeBase = ((CellBase)strainModel.getValueAt(row, genotypeColumn));
            CellBase lineBase = ((CellBase)strainModel.getValueAt(row, alleleColumn));
            String existing = lineBase.getValueAsString();
            if (existing.equals("")) {
                String genotype = geneotypeBase.getValueAsString() + ";" + line;
                geneotypeBase.setValue(genotype);
                lineBase.setValue(line);                
            }else {
                String genotype = geneotypeBase.getValueAsString();
                int i = genotype.lastIndexOf(';');
                genotype = genotype.substring(0,i+1) + line;
                geneotypeBase.setValue(genotype);
                lineBase.setValue(line);                
            }

        }
    }
    static String[] inits = {"Pending"};
}
