/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.AWS;
import org.rhwlab.LMS.RNASeq.Aligning;
import org.rhwlab.LMS.RNASeq.Finisher;
import org.rhwlab.LMS.RNASeq.SequencingID;
import org.rhwlab.LMS.RNASeq.md5.MD5sum;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class RNASeqAlignmentPanel extends TrackingPanel  implements ActionListener{
    public RNASeqAlignmentPanel(){
        super(true,inits);
        buildMenu();
        
    }
    
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("RNASeq");    
        
        JMenuItem align = new JMenuItem(alignmentItem);
        align.addActionListener(this);
        menu.add(align);      

       
        JMenuItem wig = new JMenuItem(noWig);
        wig.addActionListener(this);
        menu.add(wig); 
        
        JMenuItem plusItem = new JMenuItem(plus);
        plusItem.addActionListener(this);
        menu.add(plusItem);
       
        JMenuItem exp = new TransferMenuItem(individItem,"Expression",RNASeqAlignmentPanel.this);
        menu.add(exp);           
        
        JMenuItem express = new JMenuItem(expressionItem);
        express.addActionListener(this);
        menu.add(express); 
        
        JMenuItem fast = new JMenuItem(fastqItem);
        fast.addActionListener(this);
        menu.add(fast);
        
        JMenuItem update = new JMenuItem(updateDates);
        update.addActionListener(this);
        menu.add(update);
        
        
        JMenuItem fin = new JMenuItem(finish);
        fin.addActionListener(this);
        menu.add(fin); 
        
        JMenuItem md = new JMenuItem(md5);
        md.addActionListener(this);
        menu.add(md);     
        
        
        JMenuItem up = new JMenuItem(upload);
        up.addActionListener(this);
        menu.add(up);        
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        if (e.getActionCommand().equals(alignmentItem)||e.getActionCommand().equals(noWig)||e.getActionCommand().equals(plus)){
            
            // check all the rows can be submitted
            for (int i=0 ; i<rows.length ;++i){
                if (!canAlign(rows[i])){
                    return;
                }
            }
            
            for (int i=0 ; i<rows.length ;++i){
                int alignerColumn = this.getConfig().getColumn("Aligner");
                Aligning aligner = (Aligning)this.getModel().getValueAt(rows[i],alignerColumn);
                try {
                    String type ="XOME";
                    if (e.getActionCommand().equals(alignmentItem)){
                        type ="WIG";
                    } else if (e.getActionCommand().equals(plus)){
                        type = "PLUS";
                    }
//                    aligner.submit(type);
                    this.updateDB();
                    Thread.sleep(500);
                }catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }
        else if (e.getActionCommand().equals(expressionItem)){
            SpreadSheetPanel expPanel  = this.getConfig().getPanel(this.getConfig().getTransfer("Expression").getPanelClass());
//            SpreadSheetPanel expPanel  = this.getConfig().getPanel("org.rhwlab.LMS.views.RNASeqExpressionPanel");
            if (expPanel == null) return;
            
            // check all the rows can be submitted
            for (int i=0 ; i<rows.length ;++i){
                if (!canExpression(rows[i])){
                    return;
                }
            }             
            // group the selected rows by library
            TreeMap<String,List> libMap = new TreeMap<>();
            for (int i=0 ; i<rows.length ;++i){
                String lib = this.getValue(rows[i],"LibraryID");
                List rowList = libMap.get(lib);
                if (rowList == null){
                    rowList = new ArrayList<Integer>();
                    libMap.put(lib, rowList);
                }
                rowList.add(new Integer(rows[i]));
            }
            

            SpreadSheetModel expModel = expPanel.getModel();
            for (String lib : libMap.keySet()){
                int expRow = expModel.addEmptyRow();                
                List rowList = libMap.get(lib);
                String user = this.getValue((Integer)rowList.get(0),"UserName");
                String dset = this.getValue((Integer)rowList.get(0),"DataSet");     
                expPanel.moveToRow(expRow);
                expModel.setValue(expRow,"LibraryID", lib, true);
                expModel.setValue(expRow,"DataSet", dset, true);
                expModel.setValue(expRow,"UserName", user, true); 
//                JsonArrayBuilder bamBuilder = Json.createArrayBuilder();
                JsonArrayBuilder alignBuilder = Json.createArrayBuilder();
                for (Object obj : rowList){
                    int row = (Integer)obj;
//                    bamBuilder.add(this.getValue(row,"Directory")+"/Aligned.out.bam");
                    alignBuilder.add(this.getValue(row,"SequencingID")) ;                   
                }
//                expModel.setValue(expRow,"BAMs",bamBuilder.build(), true);
                expModel.setValue(expRow,"AlignmentIDs",alignBuilder.build(), true);                
            }
           
        } 
        else if (e.getActionCommand().equals(fastqItem)){
            if (rows.length < 2){
                JOptionPane.showMessageDialog(this,"Select at least 2 rows with the same library");
                return;
            }  
            String library = this.getValue(rows[0],"Library");
            
            //make sure the library is the same for all the runs
            
            for (int i=1 ; i<rows.length ; ++i){
                String otherLibrary = this.getValue(rows[i], "Library");
                if (!library.equals(otherLibrary)){
                    JOptionPane.showMessageDialog(this,"Libraries must be the same to combine lanes/fastq");
                    return;
                }
            }
         
            ArrayList<String> list1 = new ArrayList<>();
            ArrayList<String> list2 = new ArrayList<>();
            boolean paired = !this.getValue(rows[0], "Fastq2").equals("");
            for (int i=0 ; i<rows.length ; ++i){
                String f1 = this.getValue(rows[i], "Fastq1");
                if (!f1.equals("")){
                    list1.add(f1);
                } else {
                    JOptionPane.showMessageDialog(this,"Fastq1 file must be specified for combining lanes");
                    return;                    
                }
                String f2 = this.getValue(rows[i], "Fastq2");
                if (!f2.equals("")){
                    if (paired){
                        list2.add(f2);
                    }
                }else {
                    if (paired){
                        JOptionPane.showMessageDialog(this,"Fastq2 file must be specified for combining paired lanes");
                        return;                         
                    }
                }                
            }            

            int row = this.getModel().addEmptyRow();
            StringBuilder builder1 = new StringBuilder();
            if (!list1.isEmpty()){
                builder1.append(list1.get(0));
            }
            for (int i=1 ; i<list1.size() ; ++i){
                builder1.append(",");
                builder1.append(list1.get(i));
            }
            this.getModel().setValue(row,"Fastq1", builder1.toString(), true);
            
            StringBuilder builder2 = new StringBuilder();
            if (!list2.isEmpty()){
                builder2.append(list2.get(0));
            }
            for (int i=1 ; i<list2.size() ; ++i){
                builder2.append(",");
                builder2.append(list2.get(i));
            }
            this.getModel().setValue(row,"Fastq2", builder2.toString(), true);            
            this.getModel().setValue(row,"Library",library, true);
            
        } 
        else if (e.getActionCommand().equals(updateDates)){
            for (int i=0 ; i<rows.length ; ++i){
                int idColumn = this.getConfig().getColumn("SequencingID");
                SequencingID id  = (SequencingID)this.getModel().getValueAt(rows[i],idColumn);   
                try {
//                    id.updateAlignDates();
                } catch (Exception exc){
                    
                }
            }
        }
        else if (e.getActionCommand().equals(md5)){
            for (int i=0 ; i<rows.length ; ++i){
                int idColumn = this.getConfig().getColumn("MD5s");
                MD5sum id  = (MD5sum)this.getModel().getValueAt(rows[i],idColumn);   
                try {
                    id.updateAll();
                } catch (Exception exc){
                    
                }
            }
        }   
        else if (e.getActionCommand().equals(upload)){
            String server = this.getConfig().getJsonConfig("file").getServer();
            for (int i=0 ; i<rows.length ; ++i){
                int idColumn = this.getConfig().getColumn("DCCResponse");
                AWS id  = (AWS)this.getModel().getValueAt(rows[i],idColumn);   
                try {
                    id.submit(server);
                } catch (Exception exc){
                    
                }
            }
        }        
        else if (e.getActionCommand().equals(finish)){
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    String id = this.getValue(rows[i], "SequencingID");
                    Finisher finish = new Finisher(id,"BitSeq");
                    finish.setDir(this.getValue(rows[i],"Directory"));
                    finish.alignmentCounts(id);
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        }        
    }
    private boolean canAlign(int row){

        if (this.getValue(row,"Platform").equals("") ){
            JOptionPane.showMessageDialog(this, "Platform must be specified\nNo cluster job was submitted");
            return false;            
        }
        if (this.getValue(row,"Fastq1").equals("") ){
            JOptionPane.showMessageDialog(this, "Fastq must be specified\nNo cluster job was submitted");
            return false;
        }  
        if (this.getValue(row,"Platform").equals("HiSeq") && this.getValue(row,"Fastq2").equals("")){
            JOptionPane.showMessageDialog(this, "Fastq2 must be specified with HiSeq\nNo cluster job was submitted");
            return false;            
        }
        if (this.getValue(row,"Directory").equals("")){
            JOptionPane.showMessageDialog(this, "Enter an AlignDirectory\nNo cluster job was submitted");
            return false;
        }        
        return true;
        
    }
    private boolean canExpression(int row){
        if (this.getValue(row,"AlignCompleted").equals("")){
            JOptionPane.showMessageDialog(this, "Alignment needs to be completed first\nNo cluster job was submitted");
            return false;
        } 
/*        
        if(!this.getValue(row,"LibraryID").equals(lib)){
            JOptionPane.showMessageDialog(this, "All the libraries need to be the same for expression calculation");
            return false;
        }   
*/        
        return true;
    }

    static String alignmentItem = "Submit Genome Alignment (for WIG files)";
    static String noWig = "Submit Transcriptome Alignment (for Expression)";
    static String plus = "Submit Genome Plus Alignment (for GFP/mCherry)";
    static String expressionItem = "Combined Alignments(BAMs) for Expression";
    static String individItem = "Individual Alignments(BAMs) for Expression";
    static String fastqItem = "Combine Lanes/Fastq";
    static String updateDates = "Update Dates";
    static String finish = "Calculate rRNA";
    static String md5 = "Calculate MD5s";
    static String upload = "Submit Upload Files to DCC";
//    static String bamItem = "Combine Alignments/BAM";
    static String[] inits = {"Pending"};
    
}

