/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views.RNASeq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.singlecell.Experiment;
import org.rhwlab.LMS.RNASeq.singlecell.ExperimentID;
import org.rhwlab.LMS.RNASeq.singlecell.WellID;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class SingleCellExperimentPanel extends TrackingPanel implements ActionListener {
    public SingleCellExperimentPanel() {
        super(true, inits);
        buildMenu();

    }
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("SingleCellExperiment");   
        
        JMenuItem toWells = new JMenuItem(toWellsItem);
        toWells.addActionListener(this);
        menu.add(toWells); 
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        SpreadSheetPanel wellPanel = this.getConfig().getPanel("org.rhwlab.LMS.views.RNASeq.SingleCellWellPanel");
        SpreadSheetModel wellModel = wellPanel.getModel();
        if (e.getActionCommand().equals(toWellsItem)){
            // check the rows for barcode and platform
            for (int row : rows){
                String expID = this.getValue(row, "Experiment");
                if (expID.equals("")){
                    JOptionPane.showMessageDialog(this,"Missing the  Experiment Name");
                    return;
                }
                String barcode = this.getValue(row, "Barcode");
                if (barcode.equals("")){
                    JOptionPane.showMessageDialog(this,String.format("Enter Barcode for: %s",expID));
                    return;
                }
                String platform = this.getValue(row, "Platform");
                if (platform.equals("")){
                    JOptionPane.showMessageDialog(wellPanel,String.format("Enter Platform for: %s",expID));
                }
            }
            for (int row : rows){
                String expID = this.getValue(row, "Experiment");
                String barcode = this.getValue(row, "Barcode");
                String platform = this.getValue(row, "Platform");
                String user = this.getValue(row, "UserName");
                for (int i=0 ; i<nWells ; ++i){
                    int wellModelRow  = wellModel.addEmptyRow();
                    wellModel.setValue(wellModelRow,"WellID",WellID.wellID(expID,i+1), true);
                    wellModel.setValue(wellModelRow, "ExpBarcode", barcode, true);
                    wellModel.setValue(wellModelRow, "Platform", platform, true);
                    wellModel.setValue(wellModelRow, "UserName", user, true);
                }
            }
        }
    }
    public Experiment findExperiment(String expID){
        SpreadSheetModel model = this.getModel();
        int expCol = this.getConfig().getColumn("Experiment");
        for (int r=0 ; r<model.getRowCount() ; ++r){
            Experiment ret = (Experiment)model.getValueAt(r, expCol);
            String retString = ret.getValueAsString();
            if (retString.equals(expID)){
                return ret;
            }
        }
        return null;
    }
    static int nWells = 48;
    static String[] inits = {"Pending"};
    static String toWellsItem = "Add Well Records ";
}
