/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views.RNASeq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.AWS;
import org.rhwlab.LMS.RNASeq.AlignmentID;
import org.rhwlab.LMS.RNASeq.Finisher;
import org.rhwlab.LMS.RNASeq.PCRDupRate;
import org.rhwlab.LMS.RNASeq.SequencingID;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.views.TransferMenuItem;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class SequencingPanel extends TrackingPanel  implements ActionListener{
    public SequencingPanel(){
        super(true,inits);
        buildMenu();    
    }
    
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("Sequencing");    
        
        JMenuItem alignItem = new TransferMenuItem("To Alignments","Alignment",SequencingPanel.this);
        menu.add(alignItem);         
/*        
        JMenuItem align = new JMenuItem(archive);
        align.addActionListener(this);
        menu.add(align); 
        
 
        
        JMenuItem combine = new JMenuItem(combArchive);
        combine.addActionListener(this);
        menu.add(combine); 
        
        JMenuItem calcRate = new JMenuItem(calcDupRate);
        calcRate.addActionListener(this);
        menu.add(calcRate); 
        
        JMenuItem remDups = new JMenuItem(removeDups);
        remDups.addActionListener(this);
        menu.add(remDups);
        
        JMenuItem dccFileUpload = new JMenuItem(upload);
        dccFileUpload.addActionListener(this);
        menu.add(dccFileUpload);
*/        
        JMenuItem finishItem = new JMenuItem(finisher);
        finishItem.addActionListener(this);
        menu.add(finishItem);         
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        if (e.getActionCommand().equals(archive)){
            for (int i=0 ; i<rows.length ; ++i){
                int col = this.getConfig().getColumn("SequencingID");
                SequencingID id = (SequencingID)this.getModel().getValueAt(rows[i],col);
                try {
                    id.submit();
                }catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }
        else if (e.getActionCommand().equals(finisher)){
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    Finisher finish = new Finisher(this.getValue(rows[i],"SequencingID"),"Archive");
                    finish.setDir(this.getValue(rows[i],"Directory"));
                    finish.init();
                    finish.run();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }            
        }
        else if (e.getActionCommand().equals(upload)){
            String server = this.getConfig().getJsonConfig("file").getServer();
            for (int i=0 ; i<rows.length ; ++i){
                int idColumn = this.getConfig().getColumn("DCCResponse");
                AWS id  = (AWS)this.getModel().getValueAt(rows[i],idColumn);   
                try {
                    id.submit(server);
                } catch (Exception exc){
                    
                }
            }
        } 
        else if (e.getActionCommand().equals(calcDupRate)){
            for (int i=0 ; i<rows.length ;++i){
                
                // find a genomic alignment
                int seqIDCol = this.getConfig().getColumn("SequencingID");
                String seqID = ((CellBase)this.getModel().getValueAt(rows[i], seqIDCol)).getValueAsString();
                try {
                    String[] genomeAligns = AlignmentID.findGenomicAlignments(seqID).toArray(new String[0]);
                    if (genomeAligns.length ==0 ){
                        JOptionPane.showMessageDialog(this, String.format("No genomic alignment found for %s\ndupication rate cannot be calculated", seqID));
                        continue;
                    }
                    String genomeAlign = genomeAligns[0];
                    if (genomeAligns.length >1){
                        Object sel  = JOptionPane.showInputDialog(this, "Select alignment","Genomic Alignments",JOptionPane.QUESTION_MESSAGE,null, genomeAligns, genomeAligns[0]);
                        if (sel == null){
                            return;
                        }
                        genomeAlign = (String)sel;
                    }
                    if (genomeAlign != null){
                        int pcrColumn = this.getConfig().getColumn("PCRDupRate");
                        PCRDupRate pcr  = (PCRDupRate )this.getModel().getValueAt(rows[i],pcrColumn);  
                        pcr.submitSeldup(genomeAlign);
                        Thread.sleep(1000);
                    }
                    
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }     
        else if (e.getActionCommand().equals(removeDups)){
            for (int i=0 ; i<rows.length ;++i){
                int seqIDCol = this.getConfig().getColumn("SequencingID");
                String seqID = ((CellBase)this.getModel().getValueAt(rows[i], seqIDCol)).getValueAsString();                
                int pcrColumn = this.getConfig().getColumn("PCRDupRate");
                PCRDupRate pcr  = (PCRDupRate )this.getModel().getValueAt(rows[i],pcrColumn);  
                if (pcr.getValueAsString().equals("")){
                    JOptionPane.showMessageDialog(this, String.format("Calculate PCR dupication rate for %s before removing duplicates", seqID));
                    continue;
                }
                    try{
                        pcr.submitRemoveDups();
                        Thread.sleep(1000);     
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
            }   
        }
        else if (e.getActionCommand().equals(combArchive)){
            // make sure all the records come from the same library
            if (rows.length < 2){
                JOptionPane.showMessageDialog(menu, "Select at least two sequencing archives");
                return;
            }
            int platCol = this.getConfig().getColumn("Platform");
            int libIDCol = this.getConfig().getColumn("LibraryID");
            int userCol = this.getConfig().getColumn("UserName");
            int datasetCol = this.getConfig().getColumn("DataSet");
            int geneCol = this.getConfig().getColumn("Gene");
            int wbGeneCol = this.getConfig().getColumn("WBGene");
            int speciesCol = this.getConfig().getColumn("Species");
            String libID = ((CellBase)this.getModel().getValueAt(rows[0], libIDCol)).getValueAsString();
            String platform = "Combined";
            String username = ((CellBase)this.getModel().getValueAt(rows[0], userCol)).getValueAsString();
            String dataset = ((CellBase)this.getModel().getValueAt(rows[0], datasetCol)).getValueAsString();
            String gene = ((CellBase)this.getModel().getValueAt(rows[0], geneCol)).getValueAsString();
            String wbgene = ((CellBase)this.getModel().getValueAt(rows[0], wbGeneCol)).getValueAsString();
            String species = ((CellBase)this.getModel().getValueAt(rows[0], speciesCol)).getValueAsString();
            for (int i=1 ; i<rows.length ;++i){
                if (!libID.equals(((CellBase)this.getModel().getValueAt(rows[i], libIDCol)).getValueAsString())){
                    JOptionPane.showMessageDialog(menu, "Not all the selected archives are from the same library");
                    return;
                }
               
            }
            int row = this.getModel().addEmptyRow();
            
            StringBuilder builder1 = new StringBuilder();
            StringBuilder builder2 = new StringBuilder();
            int fastq1Col = this.getConfig().getColumn("Fastq1Archive");
            int fastq2Col = this.getConfig().getColumn("Fastq2Archive");
            for (int i=0 ; i<rows.length ;++i){
                if (i > 0){
                    builder1.append(",");
                    builder2.append(",");
                }
                builder1.append(((CellBase)this.getModel().getValueAt(rows[i], fastq1Col)).getValueAsString());
                builder2.append(((CellBase)this.getModel().getValueAt(rows[i], fastq2Col)).getValueAsString());
            }
            this.getModel().setValue(row,"DataSet",dataset, true);
            this.getModel().setValue(row,"UserName",username, true);
            this.getModel().setValue(row,"Fastq1", builder1.toString(), true);
            this.getModel().setValue(row,"Fastq2", builder2.toString(), true);            
            this.getModel().setValue(row,"LibraryID",libID, true);    
            this.getModel().setValue(row,"Platform",platform, true);
            this.getModel().setValue(row,"Species",species, true);
            
            this.getModel().setValue(row,"Gene",gene, true);
            this.getModel().setValue(row,"WBGene",wbgene, true);
            
            int col = this.getConfig().getColumn("SequencingID");
            SequencingID id = (SequencingID)this.getModel().getValueAt(row,col); 
            try {
//                id.submit();
            } catch (Exception exc){
                exc.printStackTrace();
            }
        }
    }
    static String[] inits = {"Pending"};
    static String archive = "Submit the Archiving of Fastq";
    static String finisher = "Compute md5sums";
    static String upload  = "Submit Fastq to the DCC";
    static String calcDupRate = "Calc PCR duplication rate";
    static String removeDups = "Remove PCR duplicates";
    static String combArchive = "Combining Archives";
}
