/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views.RNASeq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.AWS;
import org.rhwlab.LMS.RNASeq.Aligning;
import org.rhwlab.LMS.RNASeq.Finisher;
import org.rhwlab.LMS.RNASeq.md5.BAMFile;
import org.rhwlab.LMS.RNASeq.md5.MD5sum;
import org.rhwlab.LMS.RNASeq.views.MatrixDisplayFrame;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.LMS.views.TransferMenuItem;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class AlignmentPanel extends TrackingPanel  implements ActionListener{
    public AlignmentPanel(){
        super(true,inits);
        buildMenu();    
    }
    
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("Alignment");    
 /*       
        JMenuItem align = new JMenuItem(submitAlign);
        align.addActionListener(this);
        menu.add(align); 
        
        JMenuItem countRNA = new JMenuItem(rRNAReads);
        countRNA.addActionListener(this);
        menu.add(countRNA);
*/
        JMenuItem mergeItem = new JMenuItem(merge);
        mergeItem.addActionListener(this);
        menu.add(mergeItem);
        
        JMenuItem alignItem = new TransferMenuItem("Copy to Alignments","Alignment",AlignmentPanel.this);
        menu.add(alignItem); 
/*        
        JMenuItem combined = new JMenuItem(combinedItem);
        combined.addActionListener(this);
        menu.add(combined);
        
        JMenuItem exp = new TransferMenuItem(individualItem,"Expression",AlignmentPanel.this);
        menu.add(exp);   
        
 

 //       JMenuItem ref = new JMenuItem(refCount);
 //       ref.addActionListener(this);
 //       menu.add(ref);
 
        JMenu removeMenu = new JMenu(remove);      
        JMenuItem rRNAItem = new JMenuItem(removeRNA);
        rRNAItem.addActionListener(this);
        removeMenu.add(rRNAItem);
        JMenuItem histoneItem = new JMenuItem(removeHistones);
        histoneItem.addActionListener(this);
        removeMenu.add(histoneItem);
        menu.add(removeMenu);
        
        JMenuItem anno = new JMenuItem(annotate);
        anno.addActionListener(this);
        menu.add(anno); 
      
        JMenuItem fin = new JMenuItem(finish);
        fin.addActionListener(this);
        menu.add(fin); 
        
        JMenuItem dccFileUpload = new JMenuItem(upload);
        dccFileUpload.addActionListener(this);
        menu.add(dccFileUpload);       
        
*/
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        if (rows.length==0 )return;
        
        if (e.getActionCommand().equals(submitAlign)){
            for (int i=0 ; i<rows.length ;++i){
                int alignerColumn = this.getConfig().getColumn("Aligner");
                Aligning aligner = (Aligning)this.getModel().getValueAt(rows[i],alignerColumn);
                try {
                    aligner.submit();
                    this.updateDB();
                    Thread.sleep(3000);
                }catch (Exception exc){
                    exc.printStackTrace();
                }
            }            
        }
        else if (e.getActionCommand().equals(rRNAReads)){
            int fileColumn = this.getConfig().getColumn("BAM");
            for (int i=0 ; i<rows.length ; ++i){
                BAMFile bamFile = (BAMFile)this.getModel().getValueAt(rows[i],fileColumn); 
                try {
                    bamFile.submitRibosomalCounts();
                    Thread.sleep(1000);
                    this.updateDB();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        }
        else if (e.getActionCommand().equals(merge)){
            SpreadSheetPanel mergePanel = this.getConfig().getPanel("org.rhwlab.LMS.views.RNASeq.MergedBamPanel");
            SpreadSheetModel mergeModel  = mergePanel.getModel();
            
            // check all the rows have the same library and reference
            String libId = this.getValue(rows[0], "LibraryID");
            String ref = this.getValue(rows[0], "Reference");
            String user = this.getValue(rows[0],"UserName");
            String dataset = this.getValue(rows[0],"DataSet");
            String gene = this.getValue(rows[0],"Gene");
            String wbGene = this.getValue(rows[0],"WBGene");
            String stranded = this.getValue(rows[0],"Stranded");
            String species =  this.getValue(rows[0],"Species");
            for (int i=1 ; i<rows.length ;++i){
                if (!libId.equals(this.getValue(rows[i], "LibraryID")) || !ref.equals(this.getValue(rows[i], "Reference")) ){
                    JOptionPane.showMessageDialog(this,"All LibraryIDs and References must be the same to merge alignments");
                    return;
                }
            }
            // make sure all the alignments have been completed
            boolean complete = true;
            for (int i=0 ; i<rows.length ;++i){
                if (this.getValue(rows[i],"AlignCompleted").equals("")){
                    String msg = String.format("Alignment not complete for %s", this.getValue(rows[i],"AlignmentID"));
                    JOptionPane.showMessageDialog(LabMan.labMan,msg);
                    complete = false;
                }
            }
            if (!complete) return;
            
            // gather all the AlignmentIDs and the bams into a json arrays
            // add up the mapped reads
            int genomeReads = 0;
            int totalReads = 0;
            int xomeReads =0;
            JsonArrayBuilder alignBuilder = Json.createArrayBuilder();
            JsonArrayBuilder bamBuilder = Json.createArrayBuilder();
            for (int i=0 ; i<rows.length ;++i){
                alignBuilder.add(this.getValue(rows[i],"AlignmentID"));
                int md5Col = this.getConfig().getColumn("MD5s");
                CellBase cell = (CellBase)this.getModel().getValueAt(rows[i], md5Col);                
                MD5sum md5 = (MD5sum)cell;
                for (String bam : md5.getBAMFiles()){
                    bamBuilder.add(bam);
                }
                genomeReads  = genomeReads + Integer.valueOf(this.getValue(rows[i],"GenomeMapped"));
                xomeReads  = xomeReads + Integer.valueOf(this.getValue(rows[i],"XomeMapped"));
                totalReads  = totalReads + Integer.valueOf(this.getValue(rows[i],"#Reads"));
            }
            
            if (JOptionPane.showConfirmDialog(LabMan.labMan,String.format("Adding a Merged Alignment with %d genome mapped reads",genomeReads))!=JOptionPane.YES_OPTION) return;

            // add a new row to the merged bam table
            int mergeRow = mergeModel.addEmptyRow();
            mergePanel.moveToRow(mergeRow);
            mergeModel.setValue(mergeRow,"GenomeReads",Integer.toString(genomeReads), true); 
            mergeModel.setValue(mergeRow,"XomeReads",Integer.toString(xomeReads), true); 
            mergeModel.setValue(mergeRow,"TotalReads",Integer.toString(totalReads), true); 
            mergeModel.setValue(mergeRow,"Species", species, true); 
            mergeModel.setValue(mergeRow,"Stranded", stranded, true); 
            mergeModel.setValue(mergeRow,"UserName", user, true);   
            mergeModel.setValue(mergeRow,"Reference", ref, true); 
            mergeModel.setValue(mergeRow,"DataSet", dataset, true); 
            mergeModel.setValue(mergeRow,"Gene", gene, true); 
            mergeModel.setValue(mergeRow,"WBGene", wbGene, true); 
            mergeModel.setValue(mergeRow,"AlignmentIDs",alignBuilder.build(), true);  
            mergeModel.setValue(mergeRow,"InputBAMs",bamBuilder.build(), true); 
            mergeModel.setValue(mergeRow,"LibraryID", libId, true);
        }         
        else if (e.getActionCommand().equals(combinedItem)){
            SpreadSheetPanel expPanel = this.getConfig().getPanel(this.getConfig().getTransfer("Expression").getPanelClass());
            SpreadSheetModel expModel  = expPanel.getModel();
            
            // check all the rows have the same library and reference
            String libId = this.getValue(rows[0], "LibraryID");
            String ref = this.getValue(rows[0], "Reference");
            String user = this.getValue(rows[0],"UserName");
            String dataset = this.getValue(rows[0],"DataSet");
            for (int i=1 ; i<rows.length ;++i){
                if (!libId.equals(this.getValue(rows[i], "LibraryID")) || !ref.equals(this.getValue(rows[i], "Reference")) ){
                    JOptionPane.showMessageDialog(this,"All LibraryIDs and References must be the same to combine alignments");
                    return;
                }
            }
            
            // gather all the AlignmentIDs into a json array
            JsonArrayBuilder alignBuilder = Json.createArrayBuilder();
            for (int i=0 ; i<rows.length ;++i){
                alignBuilder.add(this.getValue(rows[i],"AlignmentID")) ;
            }
            
            // add a new row to the expression table
            int expRow = expModel.addEmptyRow();
            expPanel.moveToRow(expRow);
            expModel.setValue(expRow,"LibraryID", libId, true);
            expModel.setValue(expRow,"UserName", user, true);   
            expModel.setValue(expRow,"Reference", ref, true); 
            expModel.setValue(expRow,"DataSet", dataset, true); 
            expModel.setValue(expRow,"AlignmentIDs",alignBuilder.build(), true);  
            

        }         
        else if (e.getActionCommand().equals(refCount)){
            int fileColumn = this.getConfig().getColumn("BAM");
            TreeMap<String,double[]> countMap =  new TreeMap<>();
            String[] columnNames = new String[rows.length];
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    String id = this.getValue(rows[i], "AlignmentID");
                    columnNames[i] = id;
                    BAMFile bamFile = (BAMFile)this.getModel().getValueAt(rows[i],fileColumn);   
                    TreeMap<String,Double> counts = bamFile.referenceCounts();
                    for (String ref : counts.keySet()){
                        double[] data = countMap.get(ref);
                        if (data == null){
                            data = new double[rows.length];
                            for (int j=0 ; j<data.length ; ++j){
                                data[j] = 0.0;
                            }
                            countMap.put(ref, data);
                        }
                        data[i] = counts.get(ref);
                    }


                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
            MatrixDisplayFrame frame = new MatrixDisplayFrame();
            frame.addTab(columnNames, countMap,"Reference Counts");
            frame.setVisible(true);            
        }   
        else if (e.getActionCommand().equals(finish)){
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    String id = this.getValue(rows[i], "AlignmentID");
                    Finisher finisher = new Finisher(id,"STAR");
                    finisher.run();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        } 
        if (e.getActionCommand().equals(annotate)){
            for (int i=0 ; i<rows.length ;++i){
                int bamColumn = this.getConfig().getColumn("BAM");
                BAMFile bam = (BAMFile)this.getModel().getValueAt(rows[i],bamColumn);
                try {
                    bam.submitSLAnnotation();
                    Thread.sleep(3000);
                }catch (Exception exc){
                    exc.printStackTrace();
                }
            }            
        } 
        else if (e.getActionCommand().equals(upload)){
            String server = this.getConfig().getJsonConfig("file").getServer();
            for (int i=0 ; i<rows.length ; ++i){
                int idColumn = this.getConfig().getColumn("DCCResponse");
                AWS id  = (AWS)this.getModel().getValueAt(rows[i],idColumn);   
                try {
                    id.submitAlignment(server);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }  
        else if (e.getActionCommand().equals(removeRNA) || e.getActionCommand().equals(removeHistones)){
            for (int i=0 ; i<rows.length ; ++i){
                String id = this.getValue(rows[i], "AlignmentID");
                String directory = this.getValue(rows[i],"Directory");
                File file = new File(directory,"Aligned.toTranscriptome.out.bam");
                org.rhwlab.alignment.BAM bamFile = new org.rhwlab.alignment.BAM(file);
                try {
                if (e.getActionCommand().equals(removeRNA)){
 //                   bamFile.removeRibosomal();
                } else {
//                    bamFile.removeHistones();
               }
                Finisher.updateMD5sums(directory,"RNASeqAlignment","AlignmentID" , id);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }
       
    }
    static String[] inits = {"Pending"};
    static String submitAlign = "Submit the Alignment";
    static String finish = "Run Finisher";
    static String combinedItem = "Combined Alignments(BAMs) for Expression";
    static String individualItem = "Individual Alignments(BAMs) for Expression";
    static String merge = "To MergedBAMs";
    static String refCount = "Table of Reference Counts";
    static String annotate = "Submit for SL annotation of BAM";
    static String upload  = "Upload BAM to the DCC";
    static String remove = "Remove Alignments from BAM";
    static String removeRNA = "Ribosomal RNA";
    static String removeHistones = "Histones";
    static String rRNAReads = "Submit Count rRNA Reads";
}
