/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.LMS.primer.RestrictionEnzyme;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class PrimerDesignPanel extends TrackingPanel {
    public PrimerDesignPanel(){
        super(true,inits);
        buildMenu();
    }

    private void buildMenu(){
        JMenu menu = super.getMenu();
        menu.setText("PrimerDesign");         
                
        JMenuItem order = new JMenuItem("Order Selected Primers");
        menu.add(order);
        order.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PrintStream stream = System.out;
                JFileChooser chooser = new JFileChooser();
                int chooseVal = chooser.showSaveDialog(LabMan.labMan);
                if(chooseVal == JFileChooser.APPROVE_OPTION) {
                    try {
                        stream = new PrintStream(chooser.getSelectedFile());
                    } catch (Exception exc){
                        exc.printStackTrace();
                        return;
                    }
                } else {
                    return;
                }                
                Date date = new Date();
                
                int[] sel = PrimerDesignPanel.this.getConvertedSelectedRows();
                SpreadSheetModel model = PrimerDesignPanel.this.getModel();
                int geneCol = model.findColumn("Gene");
                int designCol = model.findColumn("Design");
                int transcriptCol = model.findColumn("Transcript");

                int lsiteCol = model.findColumn("LSite");
                int rsiteCol = model.findColumn("RSite");
                
                int lprimerCol = model.findColumn("LPrimer");
                int rprimerCol = model.findColumn("RPrimer");                
                
                int orderDateCol = model.findColumn("Ordered");
                
                for (int i=0 ; i<sel.length ; ++i){
                    CellBase base = (CellBase)model.getValueAt(sel[i], lprimerCol);
                    String lprimer = base.getValueAsString();
                    base = (CellBase)model.getValueAt(sel[i], rprimerCol);
                    String rprimer = base.getValueAsString();                    
    
                    RestrictionEnzyme lsite = (RestrictionEnzyme)model.getValueAt(sel[i], lsiteCol);
                    String lsiteseq = lsite.getSequence(); 
                    RestrictionEnzyme rsite = (RestrictionEnzyme)model.getValueAt(sel[i], rsiteCol);
                    String rsiteseq = rsite.getSequence();
                    base = (CellBase)model.getValueAt(sel[i], geneCol);
                    String gene = base.getValueAsString(); 
                    base = (CellBase)model.getValueAt(sel[i], designCol);
                    String design = base.getValueAsString();                    
                    base = (CellBase)model.getValueAt(sel[i],transcriptCol);
                    String transcript = base.getValueAsString();
                    
                    stream.printf("%s_F%s aaaa%s%s Forward %s %s\n", gene,design,lsiteseq,lprimer,lsite.getValueAsString(),transcript);
                    stream.printf("%s_R%s aaaa%s%s Reverse %s %s\n", gene,design,rsiteseq,rprimer,rsite.getValueAsString(),transcript);
                    
                    base = (CellBase)model.getValueAt(sel[i],orderDateCol);
                    base.setValue(date);
                    
                    
                }                
            }
        });
        
        JMenuItem received = new JMenuItem("Import Locations");
        menu.add(received); 
        received.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Date today = new Date();
                String[] columns = new String[2];
                columns[0] = "Transcript";
                columns[1] = "Design";
                String[] values = new String[2];
                JFileChooser chooser = new JFileChooser();
                int chooseVal = chooser.showOpenDialog(LabMan.labMan);    
                if(chooseVal == JFileChooser.APPROVE_OPTION) {
                    File file = chooser.getSelectedFile();
                    String filename = file.getName();
                    String plate = filename.substring(0,filename.indexOf(".csv"));
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(file));
                        String line = reader.readLine();
                        while(line != null){
                            String[] tokens = line.split(",");
                            String well = tokens[0];
                            String[] id = tokens[1].split("_");
                            char direction = id[1].charAt(0);
                            values[1] = id[1].substring(1);
                            values[0] = tokens[3];
                            // find the record for this transcript/design
                            SpreadSheetModel model = PrimerDesignPanel.this.getModel();
                            int r = model.findRecordMatchingValues(columns, values, 0);
                            if (direction == 'F'){
                                int wellCol = model.findColumn("LeftWell");
                                CellBase base = (CellBase)model.getValueAt(r,wellCol);
                                base.setValue(well);
                                int plateCol = model.findColumn("LeftPlate");
                                base = (CellBase)model.getValueAt(r,plateCol);
                                base.setValue(plate);
                            }else {
                                int wellCol = model.findColumn("RightWell");
                                CellBase base = (CellBase)model.getValueAt(r,wellCol);
                                base.setValue(well);
                                int plateCol = model.findColumn("RightPlate");
                                base = (CellBase)model.getValueAt(r,plateCol);
                                base.setValue(plate);                                
                            }
                            int dateCol = model.findColumn("Received");
                            CellBase base = (CellBase)model.getValueAt(r,dateCol);
                            base.setValue(today);
                            line = reader.readLine();
                        }
                    } catch (Exception exc){
                        exc.printStackTrace();
                        return;
                    }
                }                
            }
        });
        

        JMenuItem addPlasmid = new TransferMenuItem("To Plasmid","Plasmid",PrimerDesignPanel.this);
        menu.add(addPlasmid);
    
    }
    static String[] inits = {"Pending"};
}
