/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class MiSeqPanel extends TrackingPanel implements ActionListener {
    public MiSeqPanel(){
        super(false,inits);
        buildMenu();
    } 
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("MiSeq");  
        
        JMenuItem align = new JMenuItem("Submit Alignment");
        align.addActionListener(this);
        menu.add(align);

        JMenuItem addPCR = new TransferMenuItem("To HiSeq","HiSeq",MiSeqPanel.this);
        menu.add(addPCR);
        
    }     

    @Override
    public void actionPerformed(ActionEvent e) {
        String param = e.paramString();
        String cmd = e.getActionCommand();
        int[] rows = this.getConvertedSelectedRows();
        int fastqColumn = this.getConfig().getColumn("FastqFile");
        int miseqIDColumn = this.getConfig().getColumn("MiSeqID");
        int datasetColumn = this.getConfig().getColumn("DataSet");
        
        for (int row : rows){
            String fastq = ((CellBase)this.getModel().getValueAt(row, fastqColumn)).getValueAsString();
            File fastqFile = new File(fastq);
            String name = fastqFile.getName();
            String id = ((CellBase)this.getModel().getValueAt(row, miseqIDColumn)).getValueAsString();
            String dataSet = ((CellBase)this.getModel().getValueAt(row, datasetColumn)).getValueAsString();
            try {
                File knockdownDir = new File("/net/waterston/vol9/knockdown");
                File knockMiSeqDir = new File(knockdownDir,"MiSeq");
                
                // make the dataset directory if needed
                File datasetDir = new File(knockMiSeqDir,dataSet);;
                if (!datasetDir.exists()){
                    datasetDir.mkdir();
                }
                
                // make the alignment directory
                File miSeqDir = new File(datasetDir,id);
                deleteFile(miSeqDir);
                miSeqDir.mkdir();
                miSeqDir.setWritable(true, false);
                miSeqDir.setReadable(true, false);
                miSeqDir.setExecutable(true, false);
                
                // build the script file for this MiSeq alignment 
                File scriptDir = new File(knockdownDir,"scripts");
                File scriptFile = new File(scriptDir,id+".sh");
                scriptFile.setReadable(true,false);
                scriptFile.setExecutable(true, false);                
                PrintWriter writer = new PrintWriter(scriptFile);
                writer.println("#! /bin/bash");
                writer.printf("cd %s\n",miSeqDir.getPath());
                writer.println("ls *.fastq.gz > seqfof");
                writer.printf("qsub -e %s -o %s RNASEQ.qsub", miSeqDir.getPath(),miSeqDir.getPath());
                writer.close();
                scriptFile.setExecutable(true, false);
            
                // build the qsub file that does the alignment and build the wig file
                writer = new PrintWriter(new File(miSeqDir,"RNASEQ.qsub"));
                writer.println("#$ -S /bin/bash");
                writer.println("#$ -l mfree=16G");
                writer.printf("/nfs/waterston/transcriptome/scripts/RNASEQ_quick/RNASeqPipeline.pl %s seqfof WS230\n",miSeqDir.getPath());
                String samtools = "/nfs/waterston/transcriptome/scripts/samtools-0.1.18/samtools";
                String ref = "/nfs/waterston/transcriptome/scripts/c_elegans.WS230.genomic.fa";
                writer.printf("cd %s\n",miSeqDir.getPath());
                writer.printf("%s mpileup -ABIf %s  %s.WS230.merge.bam | gzip -c > %s.mpileup.gz\n",samtools,ref,id,id);
                writer.printf("/nfs/waterston/transcriptome/scripts/MakeWig.pl %s.mpileup.gz %s %s\n ",id,id,id);
                writer.print("md5sum * > md5\n");
                writer.printf("chmod -R 777 %s",miSeqDir.getPath());
                writer.close();
                
                // start the alignment script running 
                ProcessBuilder pb = new ProcessBuilder("/net/waterston/vol9/knockdown/AlignMiSeq.sh",id,fastq,miSeqDir.getPath());
                Process p = pb.start();
                
                // save filename to DB
                this.getModel().setValue(row, "FastqFile", fastqFile.getName(), false);
                this.getModel().setValue(row,"AlignmentDirectory", miSeqDir.getPath(), false);
            } catch (Exception exc){
                exc.printStackTrace();
            }
            
            int kaosdfs=0;
        }
    }
    // delete a file/directory recursively
    static void deleteFile(File file){
        if (file.isDirectory()){
            File[] files = file.listFiles();
            for (File subFile : files){
                deleteFile(subFile);
            }
        } else {
            file.delete();
        }
    }
    
static String[] inits = {"Pending"};    
}
