/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.imaging.LoadDB;
import org.rhwlab.LMS.screen.ReporterAllele;
import org.rhwlab.formats.Zip;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class ImagedPanel extends TrackingPanel {
    public ImagedPanel(){
        super(true,inits);
    }
    public void stateChanged(ChangeEvent event){
        
    }    
    public JMenu getMenu() {
        JMenu menu = super.getMenu();
        menu.setText("EmbryoDB");
        
        JMenuItem updateItem = new JMenuItem("Update from EmbryoDB");
        updateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LoadDB.updateFromXML();
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        menu.add(updateItem);
        
        JMenuItem zipIt = new JMenuItem("Zip Selected Series ");
        zipIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add("java");
                cmdList.add("-jar");
                cmdList.add("/nfs/waterston/tools3/ZipMaker.jar");

                int[] sel = ImagedPanel.this.getConvertedSelectedRows();
                SpreadSheetModel model = ImagedPanel.this.getModel();
                int col = model.findColumn("Series"); 
                
                for (int i=0 ; i<sel.length ; ++i){
                    CellBase base = (CellBase)model.getValueAt(sel[i], col);
                    cmdList.add(base.getValueAsString());
                } 
                ProcessBuilder process = new ProcessBuilder(cmdList);
                process.directory(new File(System.getenv("HOME")));
                try {
                    process.start();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        menu.add(zipIt);           
        return menu;
    }  
    static String[] inits = {"Complete"};
}
