/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.LMS.dialogs.ImageColorsDialog;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.db.beans.Imaged;
import org.rhwlab.imaging.NucLocationTIFF;
import org.rhwlab.imaging.TIFFPanel;

/**
 *
 * @author gevirl
 */
public class ImagePanel extends JPanel implements ChangeListener,ActionListener {
    public ImagePanel() throws Exception {
        this.setLayout(new BorderLayout());
        colorDialog = new ImageColorsDialog(this);

        tiffPanel = new TIFFPanel();
        this.add(tiffPanel,BorderLayout.CENTER);

        
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel,BoxLayout.X_AXIS));
        planeSlider  = new JSlider(JSlider.VERTICAL,1,30,1);
        planeSlider.setPaintLabels(true);
        planeSlider.setPaintTicks(true);
        planeSlider.setMajorTickSpacing(4);
        planeSlider.addChangeListener(this);
        timeSlider = new JSlider(JSlider.VERTICAL,1,100,1);
        timeSlider.setPaintLabels(true);
        timeSlider.setPaintTicks(true);
        timeSlider.setMajorTickSpacing(50);  
        timeSlider.addChangeListener(this);
        sliderPanel.add(planeSlider);
        sliderPanel.add(timeSlider);
        this.add(sliderPanel,BorderLayout.EAST);
        
        expBox = new JCheckBox("Expression");
        expBox.setSelected(false);
        lineBox = new JCheckBox("Lineaging");
        lineBox.setSelected(true);
        bothBox = new JCheckBox("Both");
        bothBox.setSelected(false);  
        expBox.addChangeListener(this);
        lineBox.addChangeListener(this);
        bothBox.addChangeListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(lineBox);
        group.add(expBox);
        group.add(bothBox);;
        labelBox = new JCheckBox("Label cells");
        labelBox.setSelected(false);
        labelBox.addChangeListener(this);
        radiusBox = new JCheckBox("Display radius");
        radiusBox.setSelected(false);
        radiusBox.addChangeListener(this);
        JButton colorButton = new JButton("Colors");
        colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorDialog.setVisible(true);
            }
        });
        
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel,BoxLayout.X_AXIS));
        boxPanel.add(lineBox);
        boxPanel.add(expBox);
        boxPanel.add(bothBox);
        boxPanel.add(labelBox);
        boxPanel.add(radiusBox);
        boxPanel.add(colorButton);
        this.add(boxPanel,BorderLayout.SOUTH);
        
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel,BoxLayout.X_AXIS));
        fieldPanel.add(Box.createHorizontalStrut(30));
        fieldPanel.add(new JLabel("Tracking Cell: "));
        fieldPanel.add(trackingField);
        trackingField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                setTrackingCell(e.getActionCommand());
            }
        });
        
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                moveBack();
            }
        });
        fieldPanel.add(backButton);
        fieldPanel.add(Box.createHorizontalStrut(30));
        fieldPanel.add(new JLabel("Plane: "));
        planeField.addActionListener(this);
        fieldPanel.add(planeField);
        fieldPanel.add(Box.createHorizontalStrut(30));
        fieldPanel.add(new JLabel("Time: "));
        timeField.addActionListener(this);
        fieldPanel.add(timeField);
        fieldPanel.add(Box.createHorizontalStrut(30));
        this.add(fieldPanel,BorderLayout.NORTH);
        this.actionPerformed(null);
    }
    public void setSeries(SeriesEmbryo embryo,Imaged md,String imageDir,int maxTime)throws Exception{
        this.embryo = embryo;
        tiff = new NucLocationTIFF(embryo,md,imageDir);
        tiff.setTimeAndPlane(time, plane); 
        tiffPanel.setTIFF(tiff);
        timeSlider.setMaximum(maxTime);
        this.planeSlider.setMaximum(md.getPlanes());
    }
    public void setTimeAndPlane(int time,int plane){
        this.time = time;
        this.plane = plane;
        if (tiff != null) {
            tiff.setTimeAndPlane(time, plane);
        }
        timeField.setText(Integer.toString(time));
        planeField.setText(Integer.toString(plane));
        
        // update the slider positions too
        planeSlider.setValue(plane);
        timeSlider.setValue(time);
        
        this.invalidate();
        this.repaint();
    }
    private void setTrackingCell(String cellName){
        tiff.clearAnnotations();
        tiff.annotate(cellName);
        // move to the cell
        tracking = embryo.getCell(cellName);
        int t = tracking.getEndTime();
        int p = tracking.planeAtTime(t);
        setTimeAndPlane(t,p);
        trackingField.setText(cellName);
        
    }
    private void moveBack(){
        if (tracking == null) return;
        
        if (tracking.getStartTime()<time){
            int t = time -1;
            int p = tracking.planeAtTime(t);
            setTimeAndPlane(t,p);
        } else {
            // move to parent
            EmbryoCell parent = tracking.getParentCell();
            if (parent != null){
                setTrackingCell(parent.getName());
            }
        }
    }
// sliders moved or check boxes changed
    @Override
    public void stateChanged(ChangeEvent e) {
        setTimeAndPlane(timeSlider.getValue(),planeSlider.getValue());
        update();
    } 
// plane and time fields changed , or color changed
    @Override
    public void actionPerformed(ActionEvent e) {
        this.time = Integer.parseInt(this.timeField.getText());
        this.plane = Integer.parseInt(this.planeField.getText());
        this.setTimeAndPlane(time, plane);
        update();
    } 
    private void update(){
        Color lineColor = null;
        Color expColor = null;
        if (lineBox.isSelected() || bothBox.isSelected()){
            lineColor = colorDialog.getLineaging();
        }
        if (expBox.isSelected() || bothBox.isSelected()){
            expColor = colorDialog.getExpressing();
        }
        if (tiff != null) tiff.setAppearance(labelBox.isSelected(),radiusBox.isSelected());
        tiffPanel.setWhichImages(lineColor, expColor,AlphaComposite.DST_OVER);  
        this.repaint();
    }
    ImageColorsDialog colorDialog;
    EmbryoCell tracking;
    SeriesEmbryo embryo;
    String series;
    NucLocationTIFF tiff;
    TIFFPanel tiffPanel;
    JCheckBox bothBox;
    JCheckBox expBox;
    JCheckBox lineBox;
    JCheckBox labelBox;
    JCheckBox radiusBox;
    JTextField planeField = new JTextField("1");
    JTextField timeField = new JTextField("1");
    JTextField trackingField = new JTextField("");
    JButton backButton = new JButton("Back");
    String imageDir; // the image directory
    int plane = 1;
    int time = 1;
    JSlider planeSlider;
    JSlider timeSlider;


}
