/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class FlyMiSeqPanel extends TrackingPanel implements ActionListener {
    public FlyMiSeqPanel(){
        super(false,inits);
        buildMenu();
    } 
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("MiSeq");  
        
        JMenuItem align = new JMenuItem("Submit Alignment");
        align.addActionListener(this);
        menu.add(align);

        JMenuItem addPCR = new TransferMenuItem("To HiSeq","HiSeq",FlyMiSeqPanel.this);
        menu.add(addPCR);
        
    }     

    @Override
    public void actionPerformed(ActionEvent e) {
        String param = e.paramString();
        String cmd = e.getActionCommand();
        int[] rows = this.getConvertedSelectedRows();
        int fastqColumn = this.getConfig().getColumn("FastqFile");
        int miseqIDColumn = this.getConfig().getColumn("MiSeqID");
        int datasetColumn = this.getConfig().getColumn("DataSet");
        
        for (int row : rows){
            String fastq = ((CellBase)this.getModel().getValueAt(row, fastqColumn)).getValueAsString();
            File fastqFile = new File(fastq);
            String name = fastqFile.getName();
            String id = ((CellBase)this.getModel().getValueAt(row, miseqIDColumn)).getValueAsString();
            String dataSet = ((CellBase)this.getModel().getValueAt(row, datasetColumn)).getValueAsString();
            try {
                File knockdownDir = new File("/net/waterston/vol9/knockdown");
                File knockMiSeqDir = new File(knockdownDir,"flyMiSeq");
                
                // make the dataset directory if needed
                File datasetDir = new File(knockMiSeqDir,dataSet);;
                if (!datasetDir.exists()){
                    datasetDir.mkdir();
                    datasetDir.setWritable(true, false);
                    datasetDir.setReadable(true, false);
                    datasetDir.setExecutable(true, false);                    
                }
                
                // make the alignment directory
                File miSeqDir = new File(datasetDir,id);
                deleteFile(miSeqDir);
                miSeqDir.mkdir();
                miSeqDir.setWritable(true, false);
                miSeqDir.setReadable(true, false);
                miSeqDir.setExecutable(true, false);
                
                File qsubFile = new File(miSeqDir, "RNASEQ.qsub");
                
                // build the script file for this MiSeq alignment 
                File scriptDir = new File(knockdownDir,"scripts");
                File scriptFile = new File(scriptDir,id+".sh");
                scriptFile.setReadable(true,false);
                scriptFile.setExecutable(true, false);  
                
                PrintWriter writer = new PrintWriter(scriptFile);
                writer.println("#! /bin/bash");  
                writer.printf("qsub -e %s -o %s %s\n", miSeqDir.getPath(),miSeqDir.getPath(),qsubFile.getPath());
                writer.close();
                scriptFile.setReadable(true,false);
                scriptFile.setExecutable(true, false);
                scriptFile.setWritable(true, false);
            
                // build the qsub file that does the alignment and build the wig file
                writer = new PrintWriter(qsubFile);
                writer.println("#$ -S /bin/bash");
                writer.println("#$ -l mfree=16G");
                writer.println("date"); 
                writer.printf("cd %s\n",miSeqDir.getPath());
                writer.println("echo \"Starting STAR\""); 
                writer.print("/net/waterston/vol9/STAR-STAR_2.4.0i/bin/Linux_x86_64_static/STAR ");
                writer.print("--runThreadN 4 ");
                writer.printf("--genomeDir /net/waterston/vol9/STAR_Indexes/dm6 ");

                if (fastq.endsWith(".gz")){
                    writer.print("--readFilesCommand zcat ");
                }
                writer.printf("--readFilesIn %s ",fastq);
                writer.print("--outSAMtype BAM SortedByCoordinate --outWigType wiggle --quantMode TranscriptomeSAM ");
                /*
                if (stranded.equals("1")){
                    writer.print("--outWigStrand Stranded ");
                } else {
                    writer.print("--outWigStrand Unstranded ");
                }
                        */
                writer.print("--outSAMreadID Number  ");
                writer.print("--genomeLoad NoSharedMemory --outSAMattributes All  --outReadsUnmapped Fastx \n");
                writer.printf("chmod -R 777 %s\n",miSeqDir.getPath());
                writer.println("date");
                writer.close(); 
                qsubFile.setReadable(true,false);
                qsubFile.setExecutable(true, false);
                qsubFile.setWritable(true, false);
                
                // start the alignment script running 
                ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile.getPath());
                Process p = pb.start();
                
                // save filename to DB
                this.getModel().setValue(row, "FastqFile", fastqFile.getName(), false);
                this.getModel().setValue(row,"AlignmentDirectory", miSeqDir.getPath(), false);
            } catch (Exception exc){
                exc.printStackTrace();
            }
            
            int kaosdfs=0;
        }
    }
    // delete a file/directory recursively
    static void deleteFile(File file){
        if (file.isDirectory()){
            File[] files = file.listFiles();
            for (File subFile : files){
                deleteFile(subFile);
            }
        } else {
            file.delete();
        }
    }
    
static String[] inits = {"Pending"};    
}
