/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class FlyDataSetPanel extends SpreadSheetPanel {
    public FlyDataSetPanel(){
        super(false);
        buildMenu();
    }
    public JMenu getMenu(){
        return menu;
    }
    public JMenu buildMenu(){
        menu = new JMenu("Controls");
        
        JMenuItem link = new JMenuItem("Link");
        link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                link();
            }
        });
//        menu.add(link);        
        return menu;
    }
    private void link(){
        int[] rows = this.getConvertedSelectedRows();
        if (rows.length!=2){
            JOptionPane.showMessageDialog(this, "Two rows must be selected for linking");
            return;
        } 
        String gene0 = this.getValue(rows[0],"Gene");
        String gene1 = this.getValue(rows[1],"Gene");
        
        if ( (gene0.equals("")&&gene1.equals("")) || (!gene0.equals("")&&!gene1.equals("")) ){
            JOptionPane.showMessageDialog(this, "There must be one control and one non-control for linking");
            return;            
        }
        
        if (gene0.equals("")){
            link(rows[0],rows[1]);
        } else {
            link(rows[1],rows[0]);
        }
    }
    private void link(int ctl,int non){
        String control = this.getValue(ctl,"DataSet");
        String expData = this.getValue(non,"DataSet");
        this.getModel().setValue(non,"Control",control, true);
        
        // make links in the miseq and hiseq directories
        link(FlyRNASamplePanel.getMiSeq(),expData,control);
        link(FlyRNASamplePanel.getHiSeq(),expData,control);
    }
    private void link(File baseDir,String data,String control){
        File dataDir = new File(baseDir,data);
        File ctlDir = new File(baseDir,control);
        File linkFile = new File(dataDir,"control");
        if (linkFile.exists()){
            linkFile.delete();
        }
        String cmd =String.format("ln -s %s %s",ctlDir.getPath(),linkFile.getPath());
        linkFile.setExecutable(true, false);
        linkFile.setReadable(true, false);
        linkFile.setWritable(true, false);
        try {
            Runtime.getRuntime().exec(cmd);
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }
    
}
