/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.dialogs.AddAnalysisDialog;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class ConditionPanel extends TrackingPanel  implements ActionListener{
    public ConditionPanel(){
        super(false,inits);
        buildMenu();
        
    }
    
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("Conditions");    
        
        JMenuItem express = new JMenuItem(expressionItem);
        express.addActionListener(this);
        menu.add(express);   

    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        if (rows.length < 2){
            JOptionPane.showMessageDialog(this,"Select at least 2 conditons to compare");
            return;
        }
            // all the condition need to be using the same reference to define an analysis
            String first = this.getValue(rows[0], "Reference");
            for (int i=0 ; i<rows.length ; ++i){
                String next = this.getValue(rows[i], "Reference");
                if (!next.equals(first)){
                    JOptionPane.showMessageDialog(LabMan.labMan,"All the conditions should be using the same reference");
                    return;
                }
            }        
        if (e.getActionCommand().equals(expressionItem)){
            if (this.analysisDialog==null){
                this.analysisDialog = new AddAnalysisDialog(this);
            }
            this.analysisDialog.setVisible(true);
            try {
                this.analysisDialog.init();
            } catch (Exception exc){
                exc.printStackTrace();
            }
        }      
    }
    AddAnalysisDialog analysisDialog;
    static String expressionItem = "Define Analysis";
    static String[] inits = {"Pending"};
    
}

