/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class CRISPRIntegrationPanel extends TrackingPanel{
    public CRISPRIntegrationPanel(){
        super(false,inits);
        buildMenu();
    }
   
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("CRISPRIntegration");  
        
        JMenuItem integration = new TransferMenuItem("To CRISPRIntegration","Integration",CRISPRIntegrationPanel.this);
        menu.add(integration);  
        
        final TransferMenuItem addScreen = new TransferMenuItem("To Screening","Screen",CRISPRIntegrationPanel.this);
        addScreen.addListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] sel = CRISPRIntegrationPanel.this.getConvertedSelectedRows();
                SpreadSheetModel model = CRISPRIntegrationPanel.this.getModel();
                int col = model.findColumn("ToScreening");
                Date date = new Date();
                for (int i=0 ; i<sel.length ; ++i){
                    CellBase base = (CellBase)model.getValueAt(sel[i], col);
                    base.setValue(date);
                }
            }
        });
        menu.add(addScreen);  
        
        JMenuItem pcr = new TransferMenuItem("To PCR","PCR",CRISPRIntegrationPanel.this);
        menu.add(pcr);           


    }

    static String[] inits = {"Pending","Active"};

}
