/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.dialogs.AddDataSetDialog;

/**
 *
 * @author gevirl
 */
public class AndreaSamplePanel extends RNASeqSamplePanel {
    public void buildMenu(){
        super.buildMenu();

        
    }
    public void addDataSet(){
        int[] rows = AndreaSamplePanel.this.getConvertedSelectedRows();
        if (rows.length==0) return;
        
        // check all strains are the same
        String dsStrain = null;
        String gene = "";
        for (int row : rows){
            String strain = this.getValue(row,"StrainID");
            if (strain.equals("")){
                JOptionPane.showMessageDialog(this, "All samples must have a strain");
            }
            gene = this.getValue(row, "TargetGene");
            if (dsStrain == null) {
                dsStrain = strain;
            }else {
                if (!dsStrain.equals(strain)){
                    // error
                    JOptionPane.showMessageDialog(this, "All strains need to be the same in a dataset");
                    return;
                }
            }
        }        
        AddDataSetDialog dialog = new AddDataSetDialog(this);
        dialog.setDataSetName(dsStrain);
        dialog.setDescription(gene);
        dialog.init();
        String datasetID = dialog.okAction();
        int iausdf=0;
        for (int row : rows){
            this.getModel().setValue(row,"DataSet", datasetID, true);
        }
    }    
}
