/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhwlab.LMS.DateCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class Rescue {
    public Rescue(Bomb bomb,String plate,HashMap<String,String> map){
        this.bomb = bomb;
        this.plate= plate;
        if (plate.equals("")){
            this.plate = "nopl";
        }
        this.map = map;
        this.rescueID = bomb.bombID+"_"+this.plate;
        
        String integration = map.get("Integration / % WT");
        if (integration!= null && !integration.equals("")){
            this.firstIntegration = parsePercent(integration);
            if (this.firstIntegration==null){
                addToNotes("Integration / % WT",integration);
            }
        }
        String repick = map.get("Re-pick / Change in Integration / Phenotype"); 
        if (repick != null && !repick.equals("")){
            this.secondIntegration =  parsePercent(repick);
            if (this.secondIntegration==null){
                addToNotes("Re-pick / Change in Integration / Phenotype",repick);
            }            
        }
    }
    private Integer parsePercent(String s){
        Matcher matcher = percentPattern.matcher(s);
        if (matcher.matches()){
            String intStr = matcher.group(1);
            return new Integer(intStr);
        }
        return null;
    }
    // finds a set of strain to associate with this rescue given a parent strain
    public void findStrains(String parent) throws Exception {
        String sql = String.format("Select * from Strain where StrainID=\'%s\'",parent);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String allele = rs.getString("ReporterAllele");
            sql = String.format("Select * from Strain where ReporterAllele = \'%s\'", allele);
            rs = MySql.getMySql().execute(sql);
            while (rs.next()){
                strains.add(rs.getString("StrainID"));
            }
        }
    }
    public void addToNotes(String[] keys,HashMap<String,String> map){
        for (String key : keys){
            String value = map.get(key);
            if (value!=null && !value.equals("")){
                this.addToNotes(key, value);
            }
        }
    }
    final public void addToNotes(String key,String value){
        notes.append(key);
        notes.append(" : ");
        notes.append(value);
        notes.append("\n");
    }
    public void saveToDB()throws Exception {
        try {
            
            String sql = "Insert into Rescue (BombID,Plate,RescueID,Gene,Construct,Notes) values ";
            sql = sql + String.format("(\'%s\',\'%s\',\'%s\',\'%s\',\'%s\',\'%s\')",bomb.bombID,plate,rescueID,bomb.gene,bomb.construct,notes.toString());
            MySql.getMySql().execute(sql);
        } catch (Exception exc){
            System.out.printf("duplicate %s   %s    %s\n",bomb.gene,DateCell.sqlFormat.format(bomb.date),rescueID);
        }
        
        if (this.firstIntegration != null){
            String sql = String.format("Update Rescue set FirstIntegration=%d where RescueID=\'%s\'",this.firstIntegration,this.rescueID);
            MySql.getMySql().execute(sql);
        }
        if (this.secondIntegration != null){
            String sql = String.format("Update Rescue set SecondIntegration=%d where RescueID=\'%s\'",this.secondIntegration,this.rescueID);
            MySql.getMySql().execute(sql);
        }       
        if (this.toScreen != null){
            String dateStr = DateCell.sqlFormat.format(toScreen);
            String sql = String.format("Update Rescue set ToScreening=\'%s\' where RescueID=\'%s\'",dateStr,this.rescueID);
            MySql.getMySql().execute(sql);
        } 
        
        PreparedStatement state = MySql.getMySql().getStatement("Update Strain set Rescue = ? where StrainID = ?");
        // save the rescue id in all the identified strains
        for (String strain : strains){
            state.setString(1, rescueID);
            state.setString(2, strain);
            state.execute();
        }
    }
    String rescueID;
    HashMap<String,String> map;
    Bomb bomb;
    String plate;
    boolean dauers;
    Integer firstIntegration;
    Integer secondIntegration;
    Date toScreen;
    StringBuilder notes = new StringBuilder();
    
    ArrayList<String> strains = new ArrayList<String>();
    static Pattern percentPattern = Pattern.compile("\\D*(\\d+)%.*");
}
