/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import org.rhwlab.LMS.DateCell;

/**
 *
 * @author gevirl
 */
public class PrepareStrainForLoad {
    static public void main(String[] args) throws Exception {
        PrintStream stream = new PrintStream("strain.tab");
        
        stream.print("StrainID\t");
        stream.print("ReporterConstruct\t");
        stream.print("Genotype\t");
        stream.print("ReporterAllele\t");
        stream.print("Creator\t");
        stream.print("EntryDate\t");
        stream.print("-80C Box\t");
        stream.print("-80C Position\t");
        stream.print("NitrogenCanister\t");
        stream.print("NitrogenCane\t");
        stream.print("FrozenDate\t");
        stream.print("TestThawDate\t");
        stream.print("TestThawResult\t");
        stream.print("TestThawHistone\t");
        stream.print("LineageAllele\t");
        stream.print("WormClone\t");
        stream.println("Notes");
        
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String line = reader.readLine();
        String[] heads = line.split("\t");
        
        line = reader.readLine();
        while(line!=null){
            String[] tokens = line.split("\t");
            
            HashMap<String,String> map = new HashMap<String,String>();
            for (int i=0 ; i<Math.min(heads.length,tokens.length) ;++i){
                map.put(heads[i], tokens[i]);
            }
            String strainID = map.get("Strain Designation");
            String genotype= map.get("Genotype (and plate position)");
            String reportAllele = map.get("Reporter Allele");
            String reportConstruct = map.get("Reporter Construct");
            String creator = map.get("Creator");
            String entryDateStr = map.get("Entry Date");
            String neg80Box = map.get("-80C Box");
            String neg80Position = map.get("-80C Position");
            String nitroCanister = map.get("Liquid Nitrogen Canister");
            String nitroCane = map.get("Liquid Nitrogen Cane");
            String frozenDateStr = map.get("Date Frozen");
            String thawResult = map.get("Test Thaw Result");
            String thawDateStr = map.get("Test Thaw Date");
            String thawHistone = map.get("Test Thaw Histone GFP/RFP");
            String lineageAllele = map.get("Parents or Lineage Alleles");
            String wormClone = map.get("Worm Clone");
            String notes = map.get("Expression, DNA plate #, other comments");
            
            DateCell date = new DateCell();
            date.setValue(entryDateStr);
            if(date.getValueAsString().equals("")){
                if (entryDateStr!=null && !entryDateStr.equals("")){
                    notes = notes + "  Entry Date: " + entryDateStr;
                    entryDateStr = "";
                }
            } else {
                entryDateStr = date.getValueAsString();
            }
 
            date.setValue(thawDateStr);
            if(date.getValueAsString().equals("")){
                if (thawDateStr!=null && !thawDateStr.equals("")){
                    notes = notes + "  Thaw Date: " + thawDateStr;
                    thawDateStr = "";
                }
            } else {
                thawDateStr = date.getValueAsString();
            }            

            date.setValue(frozenDateStr);
            if(date.getValueAsString().equals("")){
                if (frozenDateStr!=null && !frozenDateStr.equals("")){
                    notes = notes + "  Frozen Date: " + frozenDateStr;
                    frozenDateStr = "";
                }
            } else {
                frozenDateStr = date.getValueAsString();
            } 
            
            stream.print(strainID+"\t");
            stream.print(reportConstruct+"\t");
            stream.print(genotype+"\t");
            stream.print(reportAllele+"\t");
            stream.print(creator+"\t");
            stream.print(entryDateStr+"\t");
            stream.print(neg80Box+"\t");
            stream.print(neg80Position+"\t");
            stream.print(nitroCanister+"\t");
            stream.print(nitroCane+"\t");
            stream.print(frozenDateStr+"\t");
            stream.print(thawDateStr+"\t");
            stream.print(thawResult+"\t");
            stream.print(thawHistone+"\t");
            stream.print(lineageAllele+"\t");
            stream.print(wormClone+"\t");
            stream.println(notes);
            
            
            line = reader.readLine();
        }
    }
    
}
