/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class LinkStrainToRescue {
    String strainID;
    String plasmidName;
    Date strainDate;
    String fosmidID;
    String constructID;
    String constructType;
    String gene;
    String DNAid;
    String prepId;
    Date prepDate;
    String bombId;
    String rescueId;
    String plate;
    String cloneID;
    
    static public void main(String[] args)throws Exception {
        LinkStrainToRescue link = new LinkStrainToRescue();
    }
    public LinkStrainToRescue() throws Exception {
        
        // link the plasmids
        String sql = "select * from Strain S join Plasmid P on S.ConstructID = P.PlasmidID where S.Rescue is null and S.ConstructType='Plasmid' and (S.IsCross is null or S.IsCross=0) ";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            strainID = rs.getString("StrainID");
            plasmidName = rs.getString("PlasmidName");
            constructID = rs.getString("PlasmidID");
            constructType = "Plasmid";
            plate = rs.getString("WormClone");
            if (plate == null) plate = "0";
            strainDate = rs.getDate("EntryDate");
            System.out.printf("%s   %s    %s\n", strainID,constructID,strainDate.toString());
            gene = rs.getString("Gene");
            
            ResultSet joinRS = this.PlasmidStrainToRescueJoin();
            while(joinRS.next()){
                this.cloneID = joinRS.getString("CloneId");
                this.prepId = joinRS.getString("PrepID");
                this.prepDate = joinRS.getDate("PrepDate");
                
                if (prepDate != null){
                    System.out.printf("\t %s\n", prepDate.toString());
                    
                    if (prepDate.toString().equals("2008-01-01")) {
                        prepDate = strainDate;
                        String update = "update DNAPrep set PrepDate = ? where PrepID = ?";
                        PreparedStatement s = MySql.getMySql().getStatement(update);
                        s.setDate(1, prepDate);
                        s.setString(2, this.prepId);
 //                       s.execute();
                    }
                }
                this.bombId = joinRS.getString("BombID");
                this.rescueId = joinRS.getString("RescueID");
                this.DNAid = joinRS.getString("DNAId");
                if (prepDate == null || prepDate.compareTo(strainDate)<=0){
                    if (this.rescueId != null ){
                        // just put rescue id into strain record
                        System.out.printf("\t%s  %s\n", this.strainID,this.rescueId);
                        this.updateRescueInStrain();
                        break;
                    } else if(this.bombId != null){
                        addRescue();
                        this.updateRescueInStrain();
                        break;
                    } else if (this.prepId != null){
                        addBomb();
                        addRescue();
                        this.updateRescueInStrain();
                        break;
                    } else if(this.cloneID !=null ){
                        this.DNAid = this.cloneID;
                        addPrep();
                        addBomb();
                        addRescue();
                        this.updateRescueInStrain();
                        break;
                    }
                }
                
            }

        }
       
        // link the fosmids
        sql ="select * from Strain S join Fosmid F on S.ConstructID=F.FosmidID where S.Rescue is null and S.ConstructType=\'Fosmid\'  and (S.IsCross is null or S.IsCross=0)";
        rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            strainID = rs.getString("StrainID");

            fosmidID = rs.getString("FosmidID");
            constructID = fosmidID;
            constructType = "Fosmid";
            plate = rs.getString("WormClone");
            if (plate == null) plate = "0";
            strainDate = rs.getDate("EntryDate");
             System.out.printf("%s   %s    %s\n", strainID,constructID,strainDate.toString());
            gene = rs.getString("Gene");
            this.DNAid = fosmidID;
            
            ResultSet joinRS = this.FosmidStrainToRescueJoin();
            while(joinRS.next()){
                this.prepId = joinRS.getString("PrepID");
                this.prepDate = joinRS.getDate("PrepDate");
                if (prepDate != null) System.out.printf("\t %s\n", prepDate.toString());
                this.bombId = joinRS.getString("BombID");
                this.rescueId = joinRS.getString("RescueID");
                this.DNAid = joinRS.getString("DNAId");
                if (prepDate == null || prepDate.compareTo(strainDate)<=0){
                    if (this.rescueId != null ){
                        // just put rescue id into strain record
                        System.out.printf("\t%s  %s\n", this.strainID,this.rescueId);
                        this.updateRescueInStrain();
                        break;
                    } else if(this.bombId != null){
                        addRescue();
                        this.updateRescueInStrain();
                        break;
                    } else if (this.prepId != null){
                        addBomb();
                        addRescue();
                        this.updateRescueInStrain();
                        break;
                    } else {
                        this.DNAid = this.fosmidID;
                        addPrep();
                        addBomb();
                        addRescue();
                        this.updateRescueInStrain();
                        break;
                    }
                }
                
            } 
           

        }
        
    }
    private ResultSet PlasmidStrainToRescueJoin()throws Exception {
        String formatString = "select S.StrainID,S.Gene,S.EntryDate,P.PlasmidID,C.CloneId,D.PrepID,D.PrepDate,D.DNAId,B.BombID,R.RescueID from " +
                "Strain S left join Plasmid P on S.ConstructID=P.PlasmidID left join "+
                "Clone C on P.PlasmidID=C.ConstructID left join DNAPrep D on C.CloneId=D.DNAId left join Bomb B on " +
                "B.DNAPrepID=D.PrepID left join Rescue R on B.BombID=R.BombID where S.StrainID=\'%s\' order by D.PrepDate desc";
        String sql = String.format(formatString, strainID);
        return MySql.getMySql().execute(sql);
    }
    private ResultSet FosmidStrainToRescueJoin()throws Exception {
        String formatString = 
            "select S.StrainID,S.Gene,S.EntryDate,F.FosmidID,D.PrepID,D.PrepDate,D.DNAId,B.BombID,R.RescueID from " + 
            "Strain S left join Fosmid F on S.ConstructID=F.FosmidID left join " +
            "DNAPrep D on F.FosmidID=D.DNAId left join Bomb B on B.DNAPrepID=D.PrepID left join Rescue R on B.BombID=R.BombID " + 
            "where S.StrainID=\'%s\' order by D.PrepDate desc"; 
        String sql = String.format(formatString, strainID);
        return MySql.getMySql().execute(sql);        
    }

    
    private void updateRescueInStrain() throws Exception{
        String sql = String.format("update Strain set Rescue = \'%s\' where StrainID=\'%s\'",this.rescueId,this.strainID);
        MySql.getMySql().execute(sql);
    }
    private void addRescue()throws Exception {
        this.rescueId = this.bombId+"_"+plate;
        System.out.printf("\tRescue:  %s\n",rescueId);
        
        PreparedStatement state = 
                MySql.getMySql().getStatement("Insert into Rescue (RescueID,Plate,Notes,BombID,Gene,Construct) values(?,?,?,?,?,?)");
        state.setString(1, rescueId);
        state.setString(2, plate);
        state.setString(3, "Phantom");
        state.setString(4, bombId);
        state.setString(5, gene);
        state.setString(6, constructType);
        
        state.execute();
        
        // add the tracking info
        state = MySql.getMySql().getStatement("Insert into LMSTracking (ID,DBTable,Project,Status) values (?,?,?,?)");
        state.setString(1, rescueId);
        state.setString(2, "Rescue");
        state.setString(3, "Imaging");
        state.setString(4, "Complete");
        try {
            state.execute();  
        }catch (Exception exc){}
        
    }    
    private void addBomb()throws Exception {
        this.bombId = this.prepId+"_0";
        System.out.printf("\tBomb: %s\n", bombId);
        
        PreparedStatement state = 
                MySql.getMySql().getStatement("Insert into Bomb (DNAPrepID,BombNumber,Notes,BombID,Gene,Construct,BombDate) values(?,?,?,?,?,?,?)");
        state.setString(1, prepId);
        state.setInt(2, 0);
        state.setString(3, "Phantom");
        state.setString(4, bombId);
        state.setString(5, gene);
        state.setString(6, constructType);
        state.setDate(7, strainDate);
        
        state.execute();
        
        // add the tracking info
        state = MySql.getMySql().getStatement("Insert into LMSTracking (ID,DBTable,Project,Status) values (?,?,?,?)");
        state.setString(1, bombId);
        state.setString(2, "Bomb");
        state.setString(3, "Imaging");
        state.setString(4, "Complete");
        try {
            state.execute();  
        }catch (Exception exc){}
        
    }
    private void addPrep()throws Exception {
        
        this.prepId = this.DNAid+"_0";
        System.out.printf("\tPrep: %s\n", prepId);
        
        PreparedStatement state = 
                MySql.getMySql().getStatement("Insert into DNAPrep (DNAId,PrepNumber,Notes,PrepID,GeneName,ConstructType,PrepDate) values(?,?,?,?,?,?,?)");
        state.setString(1, DNAid);
        state.setInt(2, 0);
        state.setString(3, "Phantom");
        state.setString(4, prepId);
        state.setString(5, gene);
        state.setString(6, constructType);
        state.setDate(7, strainDate);
        
        state.execute();
        
        // add the tracking info
        state = MySql.getMySql().getStatement("Insert into LMSTracking (ID,DBTable,Project,Status) values (?,?,?,?)");
        state.setString(1, prepId);
        state.setString(2, "DNAPrep");
        state.setString(3, "Imaging");
        state.setString(4, "Complete");
        try {
            state.execute();  
        }catch (Exception exc){}
        
    }
   
    
    static boolean idMatchesConstruct(String id,String constructID){
        // check if this is really a bomb for the construct
        int index1 = id.indexOf(' ');
        if (index1 > 0 && constructID.equals(id.substring(0, index1))) {
            return true;
        }
        else {
            int index2 = id.indexOf('#');
            if (index2 > 0 && constructID.equals(id.substring(0, index2))) {
                return true;
             } else {
                int index3 = id.indexOf('_');
                if (index3 > 0 && constructID.equals(id.substring(0, index3))) {
                    return true;                    
                 } 
                else {
                    if (index1==-1 && index2==-1 && index3==-1){
                        if (id.equals(constructID))
                           return true;
                    }
                }
            }               
        }        
        return false;
    }
    static private void linkit(String strainID,Date strainDate,String constructID,String plate,String constructType)throws Exception {
        
        // get all the bombs for the construct
        String sql = String.format("select * from Bomb where BombID like \'%s\'",constructID+"%")+ " order by BombDate";
        ResultSet rsBomb = MySql.getMySql().execute(sql);
        ArrayList<String> bombs = new ArrayList<String>();
        ArrayList<Date> dates = new ArrayList<Date>();
        if (constructType.equals("Plasmid")){
            while (rsBomb.next()){
                // check if this is really a bomb for the construct
                String bombID = rsBomb.getString("BombID");
                if (idMatchesConstruct(bombID,constructID)){
                            bombs.add(bombID);
                            dates.add(rsBomb.getDate("BombDate"));                    
                }
            }
        }
        else {
            while (rsBomb.next()){
                String bombID = rsBomb.getString("BombID");
                bombs.add(bombID);
                dates.add(rsBomb.getDate("BombDate"));                
            }
        }
        // link if only one bomb
        System.out.printf("%s  %s  %s\n", strainID,constructID,plate);        
        if (bombs.size()==1){
            String bombID = bombs.get(0);

            System.out.printf("\t%s\n", bombID);
            String rescueToLink = findBestRescue(bombID,plate);

            System.out.printf("\t\t%s\n", rescueToLink);
            sql = String.format("update Strain set Rescue=\'%s\' where StrainID=\'%s\'",rescueToLink,strainID);
            MySql.getMySql().execute(sql);
        } else {
            // find the latest bomb that is earlier than the strain date
            if (bombs.size()>0){
                int jksadgf=0;
            }
            for (int i=bombs.size()-1 ; i>=0 ; --i){
                Date bombDate = dates.get(i);
                if (bombDate!=null && bombDate.compareTo(strainDate)<=0){
                    String bombID = bombs.get(i);
                    String rescueToLink = findBestRescue(bombID,plate);
                    System.out.printf("\t%s\n", bombID);
                    System.out.printf("\t\t%s\n", rescueToLink);
                    sql = String.format("update Strain set Rescue=\'%s\' where StrainID=\'%s\'",rescueToLink,strainID);
                    MySql.getMySql().execute(sql);                    
                    break;
                }
            }
        }        
    }
    static private String findBestRescue(String bombID,String plate)throws Exception {
        String sql = String.format("select * from Rescue where BombID=\'%s\'",bombID);
        ResultSet rsRescue  = MySql.getMySql().execute(sql);
        String rescueToLink = null;
        while (rsRescue.next()){
            String rescueID = rsRescue.getString("RescueID");
            if (rescueToLink == null) rescueToLink = rescueID;
            if (rescueID.equals(bombID+"_"+plate)) {
                rescueToLink = rescueID;
                break;
            }
        }
        return rescueToLink;
    }
}
