/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhwlab.LMS.DateCell;

/**
 *
 * @author gevirl
 */
public class LatestRescue extends Rescue {
    public LatestRescue(Bomb bomb,String plate,HashMap<String,String> map) throws Exception {
        super(bomb,plate,map);
        
        String line = map.get("Expressing Line Status");
        if (line != null && !line.equals("")) {
            Matcher matcher = rwPattern.matcher(line);
            if (matcher.matches()){
                String strain = matcher.group(1);
                super.findStrains(strain);
            } else {
                matcher = opPattern.matcher(line);
                if (matcher.matches()){
                    String strain = matcher.group(1);
                    super.findStrains(strain);                
                } else {
                    this.addToNotes("Expressing Line Status", line);
                }
            }
        }
        String dateStr = map.get("Date screened for expression");
        if (dateStr != null && !dateStr.equals("")){
            DateCell screenDate = new DateCell();
            screenDate.setValue(dateStr);
            this.toScreen = (Date)screenDate.getValue();  
        }
        
        this.addToNotes(noteKeys, map);

    }
    static String[] noteKeys = {"Expression?","Expression Description","Protocol Variables/Notes","Re-blast?","Reported to modENCODE"};
    static Pattern rwPattern = Pattern.compile(".*(RW\\d+).*");
    static Pattern opPattern = Pattern.compile(".*(OP\\d+).*");
}
