/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
// attempt to identify DNA preps given a gene , date and concentration
// additionally assign a storage location based on box size (either 9 or 10 per row)
public class IdentifyPrep {
    public IdentifyPrep(File file) throws Exception {
        dateState = MySql.getMySql().getStatement("select * from DNAPrep where GeneName = ? and  (PrepDate = ? or Concentration = ?)");
        noDateState = MySql.getMySql().getStatement("select * from DNAPrep where GeneName = ? ");
        
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine(); // header
        
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            
            
            List<String> prepID;
            if (tokens[1].equals("")){
                prepID = findPrep(tokens[0],null,0.0);
            } else {
                double c = 0.0;
                if (tokens[2]!=null && !tokens[2].equals(""))
                    c = Double.parseDouble(tokens[2]);
                prepID = findPrep(tokens[0],format.parse(tokens[1]),c);
            }
            
            if (prepID.size() == 0){
                notFound.add(line);
            } else if (prepID.size() == 1){
                found.add(line);
            } else {
                notUnique.add(line);
            }
            line = reader.readLine();
        }
        
        
        
    }
    // try to find the prep - empty return means not found
    private ArrayList<String> findPrep(String gene,Date date,double conc)throws Exception {
        
        if (date == null){
            state = noDateState;
        } else {
            java.sql.Date sqlDate = new java.sql.Date(date.getTime());
            state = dateState;
            state.setDate(2,sqlDate);
            state.setDouble(3, conc);
        }
        state.setString(1, gene);
        
        state.execute();
        ResultSet rs = state.getResultSet();

        ArrayList<String> ret = new ArrayList<String>();
        if (rs.next()){
            ret.add(rs.getString("PrepID"));
        }
        return ret;
    }
    public void report(PrintStream stream)throws Exception {
        for (String line : notFound){
            stream.println(line);
            String[] tokens = line.split(",");
            reportAllPreps(tokens[0],stream);
        }
    }
    public void reportAllPreps(String gene,PrintStream stream)throws Exception {
        
        PreparedStatement state = MySql.getMySql().getStatement("Select * from DNAPrep where GeneName = ?");
        state.setString(1, gene);
        state.execute();
        ResultSet rs = state.getResultSet();
        while(rs.next()){
            double c = rs.getDouble("Concentration");
            Date date = rs.getDate("PrepDate");
            if (date != null) {
                
                stream.printf("\t%s  %f\n", format.format(date),c);
            } else {
                stream.printf("\tNo date %f\n",c);
            }
        }
        
    }
    // args[0] is the csv file with input data
    // args[1] - either 9 or 10 depending of rows size of the box
    static public void main(String[] args)throws Exception {
        
        
        IdentifyPrep iPrep = new IdentifyPrep(new File(args[0]));
        PrintStream writer = new PrintStream("notFound"+args[0]);
        iPrep.report(writer);
        writer.close();
        
        iPrep = new IdentifyPrep(new File(args[1]));
        writer = new PrintStream("notFound"+args[1]);
        iPrep.report(writer);   
        
        writer.close();
    }
    ArrayList<String> found = new ArrayList<String>();
    ArrayList<String> notFound= new ArrayList<String>();
    ArrayList<String> notUnique = new ArrayList<String>();
    PreparedStatement state;
    PreparedStatement noDateState;
    PreparedStatement dateState;
    SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
}
