/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class FosmidBomb extends Bomb  {
    public FosmidBomb(Date date,String gene,String location,String strain){
        super(date,gene,location,strain,"Fosmid");
    }
    // find the appropriate DNA prep for this fosmid bomb
    public boolean findDNAPrep() throws Exception {

        TreeMap<Date,String> preps = new TreeMap<Date,String>();
        String sql = String.format("Select * from DNAPrep where Location =\'%s\' and GeneName=\'%s\' and ConstructType=\'Fosmid\'",location,gene);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            if (rs.getDate("PrepDate")!=null  ) {
                preps.put(rs.getDate("PrepDate"),rs.getString("PrepID"));
            }
            
        }
        
        sql = "Select * from Fosmid where concat(Plate,Location) = \'"+ String.format("%s\'",location);
        rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            fosmidID = rs.getString("FosmidID");
        } else {
            sql = String.format("Select * from Fosmid where TransgeneID=\'%s\'",location);
            rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                fosmidID = rs.getString("FosmidID");
                location = rs.getString("Plate")+rs.getString("Location");
            }
        }
        if (fosmidID==null) return false;  // cannot identify the fosmid - no dna prep possible        
        if (preps.isEmpty()){
            // get all the preps for the fosmid
            sql = String.format("Select * from DNAPrep where DNAId=\'%s\'",fosmidID);
            rs = MySql.getMySql().execute(sql);
            while (rs.next()){
                String prepId = rs.getString("PrepID");
                prepDate = rs.getDate("PrepDate");
                if (prepDate != null) preps.put(prepDate,prepId);
            }            
        }
        if (preps.isEmpty()) return false;
        
        // find the latest prep date <= the bomb date
        for (Date pDate : preps.descendingKeySet()){
            if (pDate.compareTo(date)<=0){
                prepID = preps.get(pDate);
                prepDate = pDate;
                return true;
            }
        }
        prepDate = preps.firstKey();
        prepID = preps.get(prepDate);
        return true;   
    }
    public String getFosmidID(){
        return this.fosmidID;
    }
    public void report(PrintStream stream){
        stream.printf("%s:%s  %s   %s\n",construct,fosmidID, gene,location);
    } 
    static public void makePreps(List<FosmidBomb> bombs,PrintStream stream){
        stream.print("Location\tGene\tDNA ID\tDate\tConstruct\n");
        for (FosmidBomb bomb : bombs){
            bomb.makePrep(stream);
        }
    }
    public void makePrep(PrintStream stream){
        stream.print(this.location);
        stream.print('\t');
        stream.print(this.gene);
        stream.print('\t');
        stream.print(this.fosmidID);
        stream.print('\t');
        stream.print(format.format(this.date));
        stream.println("\tFosmid");
        
    }
    String fosmidID=null;
    static SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yy");

}
