/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.util.HashMap;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;

/**
 *
 * @author gevirl
 */
public class FilterStrain {
    static public void main(String[] args) throws Exception {
        PrintStream blankStream = new PrintStream("blank.tab");
        PrintStream matchStream = new PrintStream("matched.tab");
        PrintStream nomatchStream = new PrintStream("nomatch.tab");
        
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String line = reader.readLine();
        blankStream.println(line);
        matchStream.println(line);
        nomatchStream.println(line);
        String[] heads = line.split("\t");
        
        line = reader.readLine();
        int l = 1;
        while(line!=null){
            String[] tokens = line.split("\t");
            
            HashMap<String,String> map = new HashMap<String,String>();
            for (int i=0 ; i<Math.min(heads.length,tokens.length) ;++i){
                
                map.put(heads[i], tokens[i]);
            }
            
            String reportConstruct = map.get("Reporter Construct");
            String genotype = map.get("Genotype (and plate position)");
            String allele = map.get("Reporter Allele");
 //           System.out.printf("%d   %s\n",l,reportConstruct);
            if (reportConstruct==null || reportConstruct.equals("")){
                blankStream.println(line);
            } else {
                String sql = String.format("Select * from Plasmid where PlasmidName=\'%s\'",reportConstruct);
                ResultSet rs = MySql.getMySql().execute(sql);
                if (rs.next()){
                    matchStream.println(line);
                    String transcript = rs.getString("Transcript");
                    Gene gene = new Gene();
                    gene.fromTranscript(MySql.getMySql(), transcript);
                    if (!genotype.contains("("+transcript) && !genotype.contains("("+gene.getSequenceName()) && !genotype.contains("("+gene.getCGC()))
                        System.out.printf("G %s %s     %s %s %s      %s\n",reportConstruct,allele,transcript,gene.getName(),gene.getSequenceName(),genotype);
                    if (!genotype.startsWith(allele)){
                        System.out.printf("A %s %s     %s %s %s      %s\n",reportConstruct,allele,transcript,gene.getName(),gene.getSequenceName(),genotype);
                    }
                } else {
                    sql = String.format("Select * from Fosmid where TransgeneID=\'%s\'",reportConstruct);
                    rs = MySql.getMySql().execute(sql);
                    if (rs.next()){
                        matchStream.println(line);
                        String wbGene = rs.getString("WBGene");
                        String location = rs.getString("Location");
                        Gene gene = new Gene();
                        gene.fromWBGene(MySql.getMySql(), wbGene);
                        if ( !genotype.contains("("+gene.getSequenceName()) && !genotype.contains("("+gene.getCGC()))
                            System.out.printf("G %s %s     %s %s      %s\n",reportConstruct,allele,gene.getName(),gene.getSequenceName(),genotype);
                        if (!genotype.startsWith(allele)){
                            System.out.printf("A %s %s     %s %s      %s\n",reportConstruct,allele,gene.getName(),gene.getSequenceName(),genotype);
                        }
                        if (!genotype.contains(location) && !genotype.contains(reportConstruct)){
                            System.out.printf("L %s %s     %s %s      %s\n",reportConstruct,allele,gene.getName(),gene.getSequenceName(),genotype);
                        }                         
                        
                    } else {
                        if (!reportConstruct.equals("n/a"))
                            nomatchStream.println(line);
                    }
                    
                }
            }
            ++l;
            line = reader.readLine();
        }
        blankStream.close();
        matchStream.close();
        nomatchStream.close();
    }
}
