/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.PrintStream;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;

/**
 *
 * @author gevirl
 */
public class Cross {
    public Cross(String offSpring,String progenitor,String lineaging,String gene){
        this.lineaging = lineaging;
        this.offSpring = offSpring;
        this.progenitor = progenitor;
        this.gene = gene;
    }
    public boolean isValid(PrintStream stream)throws Exception {
        if (this.offSpring.equals("RW11360")){
            int asdf=0;
        }
        // get the offspring strain
        String sql = String.format("Select * from Strain where StrainID = \'%s\' ",offSpring);
        ResultSet offRS = MySql.getMySql().execute(sql);
        if (!offRS.next()){
            stream.printf("OffSpring:            %s\t%s\t%s\t%s\n",offSpring,progenitor,lineaging,gene);
            return false;
        }
        sql = String.format("Select * from Strain where StrainID = \'%s\' ",progenitor);
        ResultSet proRS = MySql.getMySql().execute(sql);
        if (!proRS.next()){
            stream.printf("Progenitor:           %s\t%s\t%s\t%s\n",offSpring,progenitor,lineaging,gene);
            return false;
        }
        String reportOff = offRS.getString("ReporterAllele");
        String reportPro = proRS.getString("ReporterAllele");
        if (reportOff==null || reportPro==null || !offRS.getString("ReporterAllele").equals(proRS.getString("ReporterAllele"))){
            stream.printf("Reporter:             %s\t%s\t%s\t%s\n",offSpring,progenitor,lineaging,gene);
            return false;            
        }
        Gene dbgene = new Gene();
        dbgene.fromMySqlByCGC(MySql.getMySql(),gene);
        if (dbgene.getWBGene()==null){
            dbgene.fromMySqlBySequence(MySql.getMySql(), gene);
            if (dbgene.getWBGene()==null){
            stream.printf("Gene %s:   %s\t%s\t%s\t%s\n",gene,offSpring,progenitor,lineaging,gene);
            return false;                  
            }
        }
        
        String offGene = offRS.getString("Gene");
        if (offGene==null || (!offGene.equals(dbgene.getSequenceName())&&!offGene.equals(dbgene.getCGC()))){
            stream.printf("Gene(Offspring %s):   %s\t%s\t%s\t%s\n",offGene,offSpring,progenitor,lineaging,gene);
            return false;            
        }
        String proGene =proRS.getString("Gene");
        if (proGene==null || (!proGene.equals(dbgene.getSequenceName())&&!proGene.equals(dbgene.getCGC()))){
            stream.printf("Gene(Progenitor %s):  %s\t%s\t%s\t%s\n",proGene,offSpring,progenitor,lineaging,gene);
            return false;            
        }         
        return true;
    }
    public void dump(PrintStream stream){
        stream.printf("%s\t%s\t%s\t%s\n",offSpring,progenitor,lineaging,gene);
    }
    String offSpring;
    String progenitor;
    String lineaging;
    String gene;
}
