/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
abstract public class Bomb implements Comparable {
    public Bomb(Date date,String gene,String location,String strain,String construct){
        this.date = date;
        this.gene = gene;
        this.location = location;
        this.strain = strain;
        this.construct = construct;
    }
    abstract public boolean findDNAPrep() throws Exception ;
    @Override
    public int compareTo(Object t) {
        Bomb other = (Bomb)t;
        if (byPrep) return this.prepID.compareTo(other.prepID);
        int ret = this.date.compareTo(other.date);
        if (ret == 0) {
            ret = this.gene.compareTo(other.gene);
            if (ret == 0){
                return this.location.compareTo(other.location);
            }
        }
        return ret;
    }    

    public void report(PrintStream stream){
        stream.printf("%s:  %s   %s\n",construct, gene,location);
    }
    public static void dump(Bomb[] bombs,PrintStream stream){
        stream.println("DNAPrepID\tPrepDate\tGene\tConstruct\tLocation\tDate\tBackground Strain");
        for (Bomb bomb : bombs){
            dump(bomb,stream);
        }
    }
    public static void dump(Bomb bomb,PrintStream stream){
//        if (bomb.prepID == null) return;
        SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yy");
        
        stream.print(bomb.prepID);
        stream.print('\t');
        stream.print(format.format(bomb.prepDate));
        stream.print('\t');        
        stream.print(bomb.gene);
        stream.print('\t');
        stream.print(bomb.construct);
        stream.print('\t');
        stream.print(bomb.location);
        stream.print('\t');        
        stream.print(format.format(bomb.date));
        stream.print('\t');
        stream.println(bomb.strain);
    } 
    public void setByPrep(boolean v){
        this.byPrep = v;
    }
    public void loadFromDB()throws Exception {
        if (this.findDNAPrep()){
            String sql = String.format("Select * from Bomb where DNAPrepID=\'%s\' and BombDate=\'%s\'",prepID,sqlFormat.format(date));
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                bombID = rs.getString("BombID");
            }else {
                System.out.println("Cannot find the bomb");
                System.exit(1);
            }
        }
    }
    static SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd");  
    boolean byPrep = false;
    
    String bombID;
    String prepID;
    Date prepDate;
    
    String construct;
    Date date;
    String gene;
    String location;
    String strain;    
}
