/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import org.rhwlab.LMS.DateCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class BackLoadShipping {
    public static void main(String[] args)throws Exception {
        PrintStream stream = new PrintStream("shipping.csv");
        HashMap<String,String> dateMap = new HashMap<String,String>();
        DateCell dateCell = new DateCell();
        stream.println("Strain\tDestination\tDateShipped\tPending");
        
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String line = reader.readLine();
        String[] heads = line.split("\t");
        
        line = reader.readLine();
        while(line!=null){
            String[] tokens = line.split("\t");
            
            HashMap<String,String> map = new HashMap<String,String>();
            for (int i=0 ; i<Math.min(heads.length,tokens.length) ;++i){
                map.put(heads[i], tokens[i]);
            }
            
            String strain = map.get("Strain Designation");
            
            String cgc = map.get("Shipped to CGC");
            String yale = map.get("Shipped to Yale (Reineke)");
            String stanford = map.get("Shipped to Stanford (Kim)");
            if (cgc != null && !cgc.equals("")) dateMap.put("CGC", cgc);
            if (yale != null && !yale.equals(""))dateMap.put("Yale", yale);
            if (stanford != null && !stanford.equals(""))dateMap.put("Stanford",stanford);
            

            for (String dest : dateMap.keySet()){
                String rawDate = dateMap.get(dest);
                dateCell.setValue(rawDate);
                String dateStr = dateCell.getValueAsString();
                if (!dateStr.equals("")){
                    stream.printf("%s\t%s\t%s\t0\n", strain,dest,dateStr);
                }
            }
            line = reader.readLine();
        }
    }
}
