/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.trace;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
abstract public class TracerTree {

    abstract public void setGene(String TF) throws Exception ;
        
    
    public ArrayList<String> getDeepest(DefaultMutableTreeNode root){
        ArrayList<String> ret= new ArrayList<String>();
        int maxLevel = -1;
        Enumeration e = root.depthFirstEnumeration();
        while (e.hasMoreElements()){
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            int level = node.getLevel();
            if (level >= maxLevel){
                if (level>maxLevel){
                    ret.clear();   
                    maxLevel = level;                 
                }
                ret.add((String)node.getUserObject());
            } 
        }
        return ret;
    }
    public DefaultMutableTreeNode traceTFProtein(String gene)throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Gene"+getTracking("TFs",gene));

        // get all the Fosmids for the gene
        String sql = String.format("Select * from Fosmid where Gene=\'%s\'",gene);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String fosmidID  = rs.getString("FosmidID");
            DefaultMutableTreeNode curr = traceFosmid(fosmidID);
            ret.add(curr);
        }
        return ret;
    }     
    public DefaultMutableTreeNode traceTFPromoter(String gene)throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode(gene+getTracking("TFs",gene));

        // get all the transcripts for the gene
        String sql = String.format("Select * from TranscriptTF where Gene=\'%s\'",gene);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String transcript  = rs.getString("TranscriptName");
            DefaultMutableTreeNode curr = traceTranscript(gene,transcript);
            ret.add(curr);
        }
        return ret;
    }  
    // Trace the TF transcript 
    private DefaultMutableTreeNode traceTranscript(String gene,String transcript)throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Transcript:"+transcript+getTracking("TFs",gene));
        
        // get all the primer designs for the transcript
        String sql = String.format("Select * from PrimerDesign where Transcript=\'%s\'",transcript);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            int design = rs.getInt("Design");
            String primerID = rs.getString("PrimerID");
            DefaultMutableTreeNode curr = tracePrimer(primerID,transcript,design);
            ret.add(curr);
        }
        return ret;
    }
    private DefaultMutableTreeNode tracePrimer(String primerID,String transcript,int design) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Primer"+getTracking("PrimerDesign",primerID));
        
        // get all the plasmids for the primer
        String sql = String.format("Select * from Plasmid where Transcript=\'%s\' and Design=%d",transcript,design);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String plasmidID = rs.getString("PlasmidID");
            DefaultMutableTreeNode curr = tracePlasmid(plasmidID);
            ret.add(curr);
        }
        return ret;
    }
     private DefaultMutableTreeNode tracePlasmid(String plasmidID) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Plasmid"+getTracking("Plasmid",plasmidID));
        
        // get all the clones for the plasmid
        String sql = String.format("Select * from Clone where ConstructID=\'%s\'",plasmidID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String cloneID = rs.getString("CloneID");
            DefaultMutableTreeNode curr = traceClone(cloneID);
            ret.add(curr);
        }
        return ret;
    }
    private DefaultMutableTreeNode traceClone(String cloneID) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Clone"+getTracking("Clone",cloneID));
        
        // get all the preps for the clone
        String sql = String.format("Select * from DNAPrep where DNAID=\'%s\'",cloneID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String prepID = rs.getString("PrepID");
            DefaultMutableTreeNode curr = tracePrep(prepID);
            ret.add(curr);
        }
        return ret;
    }
    private DefaultMutableTreeNode traceFosmid(String fosmidID) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Fosmid"+getTracking("Fosmid",fosmidID));
        
        // get all the clones for the plasmid
        String sql = String.format("Select * from DNAPrep where DNAID=\'%s\'",fosmidID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String prepID = rs.getString("PrepID");
            DefaultMutableTreeNode curr = tracePrep(prepID);
            ret.add(curr); 
        }

        return ret;
    }      
    private DefaultMutableTreeNode tracePrep(String prepID) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Prep"+getTracking("DNAPrep",prepID));
        
        // get all the bombs for the prep
        String sql = String.format("Select * from Bomb where DNAPrepID=\'%s\'",prepID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String bombID = rs.getString("BombID");
            DefaultMutableTreeNode curr = traceBomb(bombID);
            ret.add(curr);
        }
        return ret;
    } 
    private DefaultMutableTreeNode traceBomb(String bombID) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Bomb"+getTracking("Bomb",bombID));
        
        // get all the bombs for the prep
        String sql = String.format("Select * from Rescue where BombID=\'%s\' ",bombID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String rescueID = rs.getString("RescueID");
           DefaultMutableTreeNode curr = traceRescue(rescueID);
            ret.add(curr);

        }        
        return ret;
    } 
    private DefaultMutableTreeNode traceRescue(String rescueID) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Rescue"+getTracking("Rescue",rescueID));
        
        // get all the progenitor strains for the rescue
        String sql = String.format("Select * from Screening where RescueID=\'%s\' ",rescueID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String screenID = rs.getString("ScreenID");
           DefaultMutableTreeNode curr = traceScreening(screenID,rescueID);
            ret.add(curr);

        }        
        return ret;        
    }  
    private DefaultMutableTreeNode traceScreening(String screenID,String rescueID) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Screening"+getTracking("Screening",screenID));
        
        // get all the progenitor strains for the screen
        String sql = String.format("Select * from Strain where Rescue=\'%s\' and (IsCross is null or IsCross=0)",rescueID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String progenitor = rs.getString("StrainID");
           DefaultMutableTreeNode curr = traceProgenitor(progenitor);
            ret.add(curr);
        }        
        return ret;        
    }    
    private DefaultMutableTreeNode traceProgenitor(String progenitor) throws Exception {
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Progenitor:"+progenitor+getTracking("Strain",progenitor));
        
        // get all the crosses for the progenitor
        String sql = String.format("Select * from Crossing where ExpressingStrain=\'%s\' ",progenitor);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String crossID = rs.getString("CrossID");
            DefaultMutableTreeNode curr = traceCross(crossID);
            ret.add(curr);
        }        
        return ret;        
    } 
    private DefaultMutableTreeNode traceCross(String crossID) throws Exception {
        String tracking = getTracking("Crossing",crossID);
        String status = tracking.substring(tracking.indexOf('(')+1,tracking.indexOf(':'));
        DefaultMutableTreeNode ret = new DefaultMutableTreeNode("Cross:"+crossID+tracking);
        if (!status.equals("Complete")) return ret;
        
        
        String crossStrain = crossID.substring(0, crossID.indexOf("_"));
        DefaultMutableTreeNode imagedNode = new DefaultMutableTreeNode("Imaging:"+crossStrain);
        ret.add(imagedNode);
        
        // get all the imaged for the cross
        String sql = String.format("Select * from Imaged where Strain=\'%s\' ",crossStrain);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String series = rs.getString("ID");
            int timePoints = rs.getInt("EditedTimePoints");
            int cells = rs.getInt("EditedCells");
            boolean published = rs.getBoolean("Publish");
            DefaultMutableTreeNode editedNode = new DefaultMutableTreeNode("Editing:"+series);
            imagedNode.add(editedNode);
            if (timePoints>0 && cells >0){
                DefaultMutableTreeNode publishNode = new DefaultMutableTreeNode("Publishing:");
                editedNode.add(publishNode);
                if (published){
                    publishNode.add(new DefaultMutableTreeNode("Complete:"));
                }                 
            }
        }
        return ret;
    }  
    
    private String getTracking(String table,String id) throws Exception {
        String sql = String.format("Select * from LMSTracking where ID=\'%s\' and DBTable=\'%s\' and Project=\'Imaging\'",id,table);
        ResultSet rs = MySql.getMySql().execute(sql);  
        if (rs.next()){
            String status = rs.getString("Status");
            String reason = rs.getString("Reason");
            if (reason == null) reason = "";
            return String.format("(%s::%s)",status,reason);
        }
        return "";
    }
    public ArrayList<String> getDeepest(){
        return deepest;
    }
    public DefaultMutableTreeNode getRoot(){
        return root;
    }
    ArrayList<String> deepest;
    DefaultMutableTreeNode root;     
}
