/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.trace;

import java.sql.ResultSet;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
// trace the progress of a transcript through the LMS
public class Tracer {
    public Tracer(){
    }
    private void addTracking(TraceResult result,String dataType,String id,String table) throws Exception{
        String sql = String.format("Select * from LMSTracking where ID=\'%s\' and DBTable=\'%s\' and Project=\'Imaging\'",id,table);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String status = rs.getString("Status");
            if (status == null) status = "";
            String reason = rs.getString("Reason");
            if (reason==null) reason = "";
            result.addReason(dataType,status,reason);
        }         
    }
    public TraceResult tracePlasmidGene(String gene)throws Exception {
        TraceResult ret = null;

        // get all the transcripts for the gene
        String sql = String.format("Select * from TranscriptTF where Gene=\'%s\'",gene);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String transcript  = rs.getString("TranscriptName");
            TraceResult curr = traceTranscript(transcript);
            ret = curr.combineWith(ret);

        }
        if (ret == null){
            ret = new TraceResult("Nothing");  // no transcripts
        }
        return ret;
    }  
    public TraceResult traceFosmidGene(String gene)throws Exception {
        TraceResult ret = null;


        // get all the fosmids for the gene
        String sql = String.format("Select * from Fosmid where Gene=\'%s\'",gene);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String fosmidID  = rs.getString("FosmidID");
            TraceResult curr = traceFosmid(fosmidID);
            ret = curr.combineWith(ret);

        }
        if (ret == null){
            ret = new TraceResult("TF");  // no transcripts
        }
        return ret;
    }  
        
    // Trace the TF transcript 
    public TraceResult traceTranscript(String transcript)throws Exception {
        TraceResult ret = null;
        
        // get all the primer designs for the transcript
        String sql = String.format("Select * from PrimerDesign where Transcript=\'%s\'",transcript);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            int design = rs.getInt("Design");
            String primerID = rs.getString("PrimerID");
            TraceResult curr = tracePrimer(primerID,transcript,design);
            ret = curr.combineWith(ret);
        }
        if (ret == null){
            ret = new TraceResult("TF");  // no primers            
        }
        addTracking(ret,"TF",transcript,"TFs");
        return ret;
    }
    
    private TraceResult tracePrimer(String primerID,String transcript,int design) throws Exception {
        TraceResult ret = null;
        
        // get all the plasmids for the primer
        String sql = String.format("Select * from Plasmid where Transcript=\'%s\' and Design=%d",transcript,design);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String plasmidID = rs.getString("PlasmidID");
            TraceResult curr = tracePlasmid(plasmidID);
            ret = curr.combineWith(ret);
        }
        if (ret == null){
            ret = new TraceResult("Primer");  // no plasmids
        }
        addTracking(ret,"Primer",primerID,"PrimerDesign");
        return ret;
    }
     private TraceResult tracePlasmid(String plasmidID) throws Exception {
        TraceResult ret = null;
        
        // get all the clones for the plasmid
        String sql = String.format("Select * from Clone where ConstructID=\'%s\'",plasmidID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String cloneID = rs.getString("CloneID");
            TraceResult curr = traceClone(cloneID);
            ret = curr.combineWith(ret);
        }
        if (ret == null){
            ret = new TraceResult("Plasmid");  // no plasmids
        }
        addTracking(ret,"Plasmid",plasmidID,"Plasmid");
        return ret;
    } 
     private TraceResult traceFosmid(String fosmidID) throws Exception {
        TraceResult ret = null;
        
        // get all the clones for the plasmid
        String sql = String.format("Select * from DNAPrep where DNAID=\'%s\'",fosmidID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String prepID = rs.getString("PrepID");
            TraceResult curr = tracePrep(prepID);
            ret = curr.combineWith(ret);
        }
        if (ret == null){
            ret = new TraceResult("Fosmid");  // no plasmids
        }
        addTracking(ret,"Fosmid",fosmidID,"Fosmid");
        return ret;
    }      
     private TraceResult traceClone(String cloneID) throws Exception {
        TraceResult ret = null;
        
        // get all the preps for the clone
        String sql = String.format("Select * from DNAPrep where DNAID=\'%s\'",cloneID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String prepID = rs.getString("PrepID");
            TraceResult curr = tracePrep(prepID);
            ret = curr.combineWith(ret);
        }
        if (ret == null){
            ret = new TraceResult("Clone");  // no plasmids
        }
        addTracking(ret,"Clone",cloneID,"Clone");
        return ret;
    } 
     private TraceResult tracePrep(String prepID) throws Exception {
        TraceResult ret = null;
        
        // get all the bombs for the prep
        String sql = String.format("Select * from Bomb where DNAPrepID=\'%s\'",prepID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String bombID = rs.getString("BombID");
            TraceResult curr = traceBomb(bombID);
            ret = curr.combineWith(ret);
        }
        if (ret == null){
            ret = new TraceResult("DNAPrep");  // no plasmids
        }
        addTracking(ret,"DNAPrep",prepID,"DNAPrep");
        return ret;
    }    
    private TraceResult traceBomb(String bombID) throws Exception {
        TraceResult ret = null;
        
        // get all the bombs for the prep
        String sql = String.format("Select * from Rescue where BombID=\'%s\' ",bombID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String rescueID = rs.getString("RescueID");
           TraceResult curr = traceRescue(rescueID);
            ret = curr.combineWith(ret);

        }        
        if (ret == null){
            ret = new TraceResult("Bomb");  // no plasmids
        }
        addTracking(ret,"Bomb",bombID,"Bomb");
        return ret;        
    }
    private TraceResult traceRescue(String rescueID) throws Exception {
        TraceResult ret = null;
        
        // get all the progenitor strains for the rescue
        String sql = String.format("Select * from Strain where Rescue=\'%s\' and (IsCross is null or IsCross=0)",rescueID);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String progenitor = rs.getString("StrainID");
           TraceResult curr = traceProgenitor(progenitor);
            ret = curr.combineWith(ret);

        }        
        if (ret == null){
            ret = new TraceResult("Rescue");  // no plasmids
        }
        addTracking(ret,"Rescue",rescueID,"Rescue");
        
        return ret;        
    }    
    private TraceResult traceProgenitor(String progenitor) throws Exception {
        TraceResult ret = null;
        
        // get all the crosses for the progenitor
        String sql = String.format("Select * from Strain where Progenitor=\'%s\' and IsCross=1",progenitor);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String cross = rs.getString("StrainID");
            TraceResult curr = traceCross(cross);
            ret = curr.combineWith(ret);

        }        
        if (ret == null){
            ret = new TraceResult("Progenitor");  // no 
        }
        addTracking(ret,"Progenitor",progenitor,"Strain");
        return ret;        
    }    
    private TraceResult traceCross(String crossStrain) throws Exception {
        TraceResult ret = null;
        
        // get all the imaged for the cross
        String sql = String.format("Select * from Imaged where Strain=\'%s\' ",crossStrain);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            TraceResult curr = null;
            int timePoints = rs.getInt("EditedTimePoints");
            int cells = rs.getInt("EditedCells");
            boolean published = rs.getBoolean("Publish");
            if (published){
                return new TraceResult("Published");
            } if (timePoints>0 && cells >0){
                curr = new TraceResult("Edited");    
            } else {
                curr = new TraceResult("Imaged");
            }
            ret = curr.combineWith(ret);

        }
        if (ret == null){
            ret = new TraceResult("Cross");
        }
        
        // get any status from the cross table
        sql = String.format("Select * from Crossing where ExpressingStrain=\'%s\'",crossStrain);
        ResultSet crossRS = MySql.getMySql().execute(sql);
        while (crossRS.next()){
            String crossID = crossRS.getString("CrossID");
            addTracking(ret,"Cross",crossID,"Crossing");
        }            
        
        return ret;        
    }       
      static public void main(String[] args) throws Exception {
          Tracer tracer = new Tracer();
          TraceResult result = tracer.traceTranscript(args[0]);
          int jksagfi = 0;
      }
}
