/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class TraceResult implements Comparable {
    public TraceResult(String far){
        this.farthest = far;
        
        if (order == null){
            buildOrder();
        }
    }
    private void buildOrder(){
        order = new TreeMap<String,Integer>();
        order.put("Nothing", -1);
        order.put("TF", 0);
        order.put("Primer",1);
        order.put("Plasmid", 2);
        order.put("Fosmid",2);
        order.put("Clone",3);
        order.put("DNAPrep", 4);
        order.put("Bomb", 5);
        order.put("Rescue",6);
        order.put("Progenitor",7);
        order.put("Cross",8);
        order.put("Imaged",9);
        order.put("Edited", 10);
        order.put("Published",11);
        
    }
    public void addReason(String type,String status,String reas){
        
        reasons.add(String.format("%s\t%s\t%s", type,status,reas));
    }
    // combine this trace result with another trace result
    // put the farthest result
    public TraceResult combineWith(TraceResult other){
        if (other == null) return this;
        
        TraceResult ret = this;
        if (this.compareTo(other) < 0 ) {
            ret = other;
            ret.reasons.addAll(this.reasons);
        } else {
            ret.reasons.addAll(other.reasons);
        }
        return ret;
    }

    @Override
    public int compareTo(Object o) {
        TraceResult other = (TraceResult)o;
        Integer farthestValue = order.get(this.farthest);
        Integer otherValue = order.get(other.farthest);
        return farthestValue.compareTo(otherValue);
    }
    public String getFarthest(){
        return this.farthest;
    }
    public ArrayList<String> getReasons(){
//        Collections.sort(reasons);
        return this.reasons;
    }
    
    String farthest;
    ArrayList<String> reasons = new ArrayList<String>();
    static TreeMap<String,Integer> order = null;
}
