/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.trace;

import javax.swing.event.ChangeEvent;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class ProteinTrace extends CellBase {
    public ProteinTrace(){
        super(new ProteinTracerTree());
    }
    public ProteinTrace(String gene)throws Exception {
        super(new ProteinTracerTree(gene));
    }
    public boolean setValue(Object v){
        return this.setValue(v, true);
    }
    public boolean setValue(Object v,boolean notify){
        String gene = (String)v;
        try {
            return super.setValue(new ProteinTracerTree(gene),notify);
        } catch (Exception exc){
            return false;
        }
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        String gene = ((CellBase)ce.getSource()).getValueAsString();
        this.setValue(gene);
    }    
    @Override
    public boolean validate(String newValue) {
        return true;
    }

    @Override
    public String getValueAsString() {
        String s = ((ProteinTracerTree)this.value).getDeepest().get(0);
        int index = s.indexOf("(");
        if (index != -1){
            return s.substring(0,index ); 
        }
        
        index = s.indexOf(":");
        if (index == -1) return s;
        return s.substring(0,index );
    }

    @Override
    public int compareTo(Object o) {
        String other = ((CellBase)o).getValueAsString();
        String strValue = this.getValueAsString();
        return strValue.compareTo(other);
    }    
}
