/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.strain;

import java.sql.ResultSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.ListCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.rescue.RescueID;
import org.rhwlab.LMS.screen.Strain;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class ConstructID extends TextCell{
    public ConstructID(){
        this("");
    }
    public ConstructID(String value){
        super(value);
//        this.inputs.put("Rescue", this);
 //       this.inputs.put("ReporterConstruct", this);
 //       this.inputs.put("Construct", this);
    }
    @Override
    public boolean validate(String newValue) {
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (locked) return;
        if (!this.getValueAsString().equals("")) return;
        
        Object source = ce.getSource();
        try {
 //           String type = inputs.get("Construct").getValueAsString();
 //           String reporter = inputs.get("ReporterConstruct").getValueAsString();
            
            // try using a rescue to find the reporter construct
            if (source instanceof RescueID){
                RescueID rescue = (RescueID)source;
                String constructID = rescue.getReporterConstruct();
                if (constructID != null){
                    super.setValue(constructID);
                    return;
                }
            } else if (source instanceof Strain){
                Strain strain = (Strain)source;
                super.setValue(strain.getConstructID());
                return;
            }
            
            // 
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }

    public String getConstructType()throws Exception {
        if (type == null){
            locate();
        }

        return type;
    }
    public String getGeneName()throws Exception {
        if (geneName == null){
            locate();
        }
        return geneName;
    }
    public String getTranscript()throws Exception {
        if (transcript == null){
            locate();
        }
        return transcript;
    }    
    @Override
    public String getValueAsString() {
        if (this.getValue() instanceof String){
            return (String)this.getValue();
        }
        return "";
    }
    private void locate() throws Exception {
        String val = this.getValueAsString();
        // is this a plasmid?
        String sql = String.format("Select * from Plasmid where PlasmidID = \'%s\'",val);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            type = "Plasmid";
            Gene gene = new Gene();
            transcript = rs.getString("Transcript");
            gene.fromTranscript(MySql.getMySql(), transcript);
            geneName = gene.getName();
        }else {
            sql = String.format("Select * from Fosmid where FosmidID = \'%s\'",val);
            rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                type = "Fosmid";
                Gene gene = new Gene();
                String wbgene = rs.getString("WBGene");
                gene.fromWBGene(MySql.getMySql(), wbgene);
                geneName = gene.getName();                
            }            
        }        
    }
    String type=null;
    String geneName=null;
    String transcript = null;
}
