/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.storage;

import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.DateCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.models.BRCStockLocation;
import org.rhwlab.LMS.models.BombModel;
import org.rhwlab.LMS.models.DNAStorageModel;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class Location extends TextCell{
    
    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.getValueAsString().equals("")){
            try {
                this.setValue(nextLocation());
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
    
    public boolean validate(String newValue){
        BRCStockLocation loc = new BRCStockLocation();
        
        return loc.parse(newValue);
    }
    
    // find the next availalble prep location
    public String nextLocation() throws Exception{
        BRCStockLocation retBRC = ((DNAStorageModel)model).maxLocation();
        
        // find the maximum for the database
        String sql = "Select Location from DNAStorage where Location is not null and Location != \'\'";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String prepLoc = rs.getString("Location");
            BRCStockLocation prepBRC = new BRCStockLocation(prepLoc);
            if (prepBRC.compareTo(retBRC)>0){
                retBRC = prepBRC;
            }
        }
        
        // look for the maximum in the spreadsheet
        retBRC.increment(9, 9);
        return retBRC.asString();
    }
}
