/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.stock;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.models.BRCStockLocation;
import org.rhwlab.LMS.models.GlycerolStockModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class StockLocation extends TextCell implements Comparable {
    public StockLocation(){
        super();
        inputs.put("Box",null);
        inputs.put("Row", null);
        inputs.put("Column",null);
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        box = ((CellBase)inputs.get("Box")).getValueAsString();
        row = ((CellBase)inputs.get("Row")).getValueAsString();
        column = ((CellBase)inputs.get("Column")).getValueAsString();
        if (box.equals("")) return;
        if (row.equals("")) return;
        if (column.equals("")) return;
        String newValue = box+row+column;
        this.setValue(newValue);
        
    }

    public String getBox(){
        return ((CellBase) inputs.get("Box")).getValueAsString();
    }
    public String getRowStr(){
        return ((CellBase) inputs.get("Row")).getValueAsString();
    }
    public String getCol(){
        return ((CellBase) inputs.get("Column")).getValueAsString();
    }
    @Override
    public int compareTo(Object t) {
        StockLocation other = (StockLocation)t;
        BRCStockLocation thisLoc = GlycerolStockModel.fromString(this.getBox(), this.getRowStr(), this.getCol());
        BRCStockLocation otherLoc = GlycerolStockModel.fromString(other.getBox(), other.getRowStr(), other.getCol());
        return thisLoc.compareTo(otherLoc);
    }
    String box;
    String row;
    String column;
}
