/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.ship;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.ShippingModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class Request extends IntegerCell {
    public Request(){
        super();
        inputs.put("Destination",null);
        inputs.put("Strain",null);
    }
    public void stateChanged(ChangeEvent ce) {
        
        CellBase base = inputs.get("Strain");
        String strain = base.getValueAsString();
        if (!strain.equals("")){
            base = inputs.get("Destination");
            String dest = base.getValueAsString();
            if (!dest.equals("")){
                ShippingModel shipModel = (ShippingModel)this.getModel();
                try {
                    int next = shipModel.nextRequest(strain, dest,this.getRow());
                    String s = Integer.toString(next);
                    this.setValue(s);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }
    }
}
