/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.scripts;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.mysql.WormBaseGene;

/**
 *
 * @author gevirl
 */
// repair (update) the Gene column in a table
// takes into account dead WBGene merged into other genes and
// synchronizes with WormBase sequence and CGC names from the WormBaseTable
public class RepairGene {
    // repair the Gene column in a table
    public void updateWBGeneFromGeneColumn(String table,String column)throws Exception {
        String update = String.format("Update %s set WBGene = ? where %s = ?",table,column);
        PreparedStatement state = MySql.getMySql().getStatement(update);
        String sql = String.format("Select distinct %s from %s",column,table);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String geneCol = rs.getString(column);
            WormBaseGene wbGene = WormBaseGene.byGeneColumn(geneCol);
            if (wbGene != null){
                state.setString(1, wbGene.getWBGene());
                state.setString(2, geneCol);
                state.execute();
            }
        }
        
    }
    public void checkGeneTable(String table,String column)throws Exception {
        String sql = String.format("Select distinct %s from %s",column,table);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String geneCol = rs.getString(column);

            WormBaseGene WBGene = null;
            WBGene = WormBaseGene.byGeneColumn(geneCol);
            if (WBGene==null){
                System.out.printf("Not Found: %s  %s\n", table,geneCol);
            }            
 //           System.out.printf("%s:   %s   %s   %s\n",geneCol,WBGene.getWBGene(),WBGene.getSequence(),WBGene.getCGC());
        }
    }
    public void checkTranscriptTable(String table,String column)throws Exception {
        String sql = String.format("Select distinct %s from %s",column,table);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String transCol = rs.getString(column);
            WormBaseGene WBGene = null;
            WBGene = WormBaseGene.byTranscript(transCol);
            if (WBGene==null){
                System.out.printf("Not Found: %s  %s\n", table,transCol);
            }             
        }        
    }    
    static public void main(String args[])throws Exception {
        RepairGene repair = new RepairGene();
        for (int i=0 ; i<transcriptTables.length;++i){
            repair.checkTranscriptTable(transcriptTables[i], transcriptColumns[i]);
        }
        for (int i=0 ;i<geneTables.length;++i){
                 repair.checkGeneTable(geneTables[i],geneColumns[i]);
        }
    }
    static String[] geneTables = {"Bomb","Crossing","DNAPrep","DNAStorage","Fosmid","Freezing","Generation",
        "GlycerolStock","Plasmid","PrimerDesign","Rescue","Screening","Strain","TFs","Thaw"};
    static String[] geneColumns = {"Gene","Gene","GeneName","Gene","Gene","Gene","Gene",
        "GeneInsert","Gene","Gene","Gene","Gene","Gene","Gene","Gene"};
    static String[] transcriptTables = {"Clone","Plasmid","PrimerDesign"};
    static String[] transcriptColumns = {"Transcript","Transcript","Transcript"};
    
}
