/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.scripts;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class FixAndreaHiSeqFastq {
    static public void main(String[] args)throws Exception {
        
        PreparedStatement state = MySql.getMySql().getStatement("update RNASequencing set Fastq1=?, Fastq2=? where SequencingID=?");
        
        String sql = "Select * from RNASequencing where Platform =\'HiSeq\'";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String id = rs.getString("SequencingID");
            String[] fastq = rs.getString("Fastq1").split(",");
            File[] fastqFiles = toFiles(fastq);
            
            System.out.println(id);
            for (int i=0 ; i<fastq.length ; ++i){
                System.out.printf("%s\t%s\n",fastq[i], fastqFiles[i].getPath());
            }
            String fastq1 = fastqFiles[0].getPath();
            String fastq2 = fastqFiles[1].getPath();
            if (fastqFiles.length ==4){
                fastq1 = String.format("%s,%s",fastq1,fastqFiles[2].getPath());
                fastq2 = String.format("%s,%s",fastq2,fastqFiles[3].getPath());
            }
            System.out.printf("fastq1=%s\n",fastq1);
            System.out.printf("fastq2=%s\n",fastq2);
            
            state.setString(1, fastq1);
            state.setString(2, fastq2);
            state.setString(3, id);
            state.execute();
            
        }
        
    }
    static File[] toFiles(String[] fastqs){
        File[] ret = new File[fastqs.length];
        ret[0] = new File(fastqs[0]);
        File dir = ret[0].getParentFile();
        for (int i=1 ; i<ret.length ; ++i){
            ret[i] = new File(dir,fastqs[i]);
        }
        return ret;
    }
}
