/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.scripts;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class FillInFosmidInfo {
    static public void main(String[] args)throws Exception {
        PrintStream writer = new PrintStream(args[0]+".filled");
        PreparedStatement strainState = MySql.getMySql().getStatement("Select ConstructID,Gene from Strain where StrainID = ?");
        PreparedStatement fosmidState = MySql.getMySql().getStatement("Select * from Fosmid where FosmidID = ?");
        
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String head = reader.readLine();
        writer.println(head);
        int n = head.split("\t").length;
        
        
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            String[] outData = new String[n];
            for (int i=0 ; i<tokens.length;++i){
                outData[i] = tokens[i];
            }
            for (int i=0 ; i<outData.length ; ++i){
                if (outData[i] == null || outData[i].equals("")){
                    outData[i] = "unknown";
                }
            }
            String strain = tokens[0].split(":")[1];
            
            // get the fosmid for the this strain
            strainState.setString(1,strain);
            ResultSet rs = strainState.executeQuery();
            if (rs.next()){
                // found the strain
                String gene = rs.getString("Gene");
                if (gene != null && tokens[1].equals("")){
                    outData[1] = gene;
                } else if (tokens[1].equals("")){
                    outData[1] = "null";
                } 
                // get the fosmid
                String fosmidID = rs.getString("ConstructID");
                fosmidState.setString(1, fosmidID);
                rs = fosmidState.executeQuery();
                if (rs.next()){
                    // fosmid found
                    String name = rs.getString("FosmidName");
                    if (name != null) outData[3] = name;
 //                   outData[3] = fosmidID;
                    String coord = rs.getString("Coordinates");
                    if (coord!=null){
                        outData[4] = coord;
                        outData[6] = Integer.toString(rs.getInt("Size"));
                    }
//                    outData[5] = rs.getString("FosmidDescr");
                    outData[5] = "pCC1FOS";
                    outData[8] = "C-terminus";
                    outData[9] = rs.getString("WBGene");
                    outData[10] = "Bombardment";
                }
                
            } 
            
            writer.print(outData[0]);
            for (int i=1 ; i<outData.length;++i){
                writer.printf("\t%s", outData[i]);
            }
            writer.println();
            line = reader.readLine();
        }
    }
}
