/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.sci;

import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/**
 *
 * @author gevirl
 */
public class UmiByCellsPanel extends JPanel{
    public UmiByCellsPanel(int[] umis){
        XYSeriesCollection collect = new XYSeriesCollection();
        XYSeries series = new XYSeries("");
        collect.addSeries(series);
        
        for (int i=0 ; i<umis.length ; ++i){
            series.add((double)i+1,(double)umis[i]);

        }

        JFreeChart chart = ChartFactory.createXYLineChart
                ("UMIs vs Cells",
                        "Cells","UMIs", collect, PlotOrientation.VERTICAL,false,true,true);
        XYPlot plot = chart.getXYPlot();
        NumberAxis rangeAxis = new LogarithmicAxis("UMIs");
        NumberAxis domainAxis = new LogarithmicAxis("Cells");
        plot.setDomainAxis(domainAxis);
        plot.setRangeAxis(rangeAxis);        
        ChartPanel panel = new ChartPanel(chart);
        this.add(panel);
    }
}
