/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.sci;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import javax.swing.JFrame;

/**
 *
 * @author gevirl
 */
public class UMIattachedSam {
    File file;
    
    public UMIattachedSam(String filePath){
        this.file = new File(filePath);
    }
    // gets UMIs associated with each barcode in this sam file
    public TreeMap<String,HashSet<String>> UMIsByBarcode(){
        
        TreeMap<String,HashSet<String>> map = new TreeMap<>();
        SamReader samReader = SamReaderFactory.makeDefault().open(file);       
        SAMRecordIterator iter = samReader.iterator();
        while (iter.hasNext()){
            SAMRecord record = iter.next();  
            String readName = record.getReadName();
            
            // parse out the barcode and umi from the readname
            String[] tokens = readName.split(",");
            String barcode = tokens[0];
            String UMI = tokens[1];
            
            // record the UMI for this barcode
            HashSet<String> umis = map.get(barcode);
            if (umis == null){
                umis = new HashSet<>();
                map.put(barcode, umis);
            }
            umis.add(UMI);
        }
        return map;
    }
    static public int[] UMIcounts(File directory){
        TreeMap<Integer,Integer> barcodes = new TreeMap<>();  // count of barcodes indexed by number of umis
        int totalBarcodes =0;
        for (File file :directory.listFiles()){
            if (file.getName().endsWith("sam")){
                UMIattachedSam sam = new UMIattachedSam(file.getPath());
                TreeMap<String,HashSet<String>> umis = sam.UMIsByBarcode();
                for (HashSet<String> umiSet : umis.values()){
                    int n = umiSet.size();
                    Integer count = barcodes.get(n);
                    if (count == null){
                        barcodes.put(n,1);
                    } else {
                        barcodes.put(n, count+1);
                    }
                    ++totalBarcodes;
                }
            }
        }
        int i = 0;
        int[] ret = new int[totalBarcodes];
        for (int umiCount : barcodes.descendingKeySet()){
            int barcodeCount = barcodes.get(umiCount);
            for (int j =0 ; j<barcodeCount ; ++j){
                ret[i+j] = umiCount;
            }
            i = i +barcodeCount;
        }
        
        return ret;
    }
    static public void main(String[] args)throws Exception {
    int[] counts = UMIattachedSam.UMIcounts(new File("/net/waterston/vol9/RNASeq/sci/2017-08-01_plate01_1/rmdup_sam"));
    JFrame frame =new JFrame();
    UmiByCellsPanel panel = new UmiByCellsPanel(counts);
    frame.setContentPane(panel);
    frame.pack();
    frame.setVisible(true);
    int iausdfiusgdfh=0;
    }
}
